import React, { Component } from 'react';
import PropTypes from 'prop-types';
import cls from 'classnames';
import { GraphIcon } from 'amos-designer';
import './index.scss';

const Item = props => {
  const { title, titleIcon, titleActiveIcon, active, titleOther, info = [] } = props;
  return (
    <div className="ccs-com-infolist-item">
      <div className="ccs-com-infolist-title">
        {titleIcon && <GraphIcon icon={active ? titleActiveIcon || titleIcon : titleIcon} />}
        <div className="ccs-com-infolist-main-title" title={title}>
          {title}
        </div>
        {title === '一般火灾' ? '' : <div className="ccs-com-infolist-other-title">{titleOther}</div>}
      </div>
      <div className="ccs-com-infolist-info">
        {(info || []).map(e => {
          return (
            <div key={e.name || e.value} className="ccs-com-infolist-info-item" style={{ width: e.width }}>
              {e.icon && <GraphIcon icon={active ? e.activeIcon || e.icon : e.icon} />}
              <div className="ccs-com-infolist-info-value" title={e.value}>
                {e.name && !e.hideLabel ? `${e.name}：` : ''}
                {e.value}
              </div>
            </div>
          );
        })}
      </div>
    </div>
  );
};
Item.propTypes = {
  title: PropTypes.oneOfType([PropTypes.string, PropTypes.node]),
  titleOther: PropTypes.oneOfType([PropTypes.string, PropTypes.node]),
  titleIcon: PropTypes.string,
  titleActiveIcon: PropTypes.string,
  active: PropTypes.any,
  info: PropTypes.array
};
/**
 * InfoList
 *
 * @class InfoList
 * @extends {Component}
 */
class InfoList extends Component {
  static Item = Item;

  static propTypes = {
    dataSource: PropTypes.array,
    rowKey: PropTypes.string,
    bgImg: PropTypes.string,
    activeBgImg: PropTypes.string,
    activeData: PropTypes.object,
    renderItem: PropTypes.func,
    onClick: PropTypes.func
  };

  static defaultProps = {
    dataSource: [],
    activeData: {},
    onClick() {},
    rowKey: 'key',
    bgImg: '/upload/sfcc/common/信息列表项背景.png',
    activeBgImg: '/upload/sfcc/common/信息列表项背景-active.png'
  };

  constructor(props) {
    super(props);
    this.state = {
      hovers: {}
    };
  }

  onMouseOver = item => {
    const { rowKey } = this.props;
    const { hovers } = this.state;
    hovers[item[rowKey]] = 1;
    this.setState({ hovers });
  };

  onMouseOut = item => {
    const { rowKey } = this.props;
    const { hovers } = this.state;
    delete hovers[item[rowKey]];
    this.setState({ hovers });
  };

  render() {
    const { dataSource, rowKey, bgImg, activeBgImg, onClick } = this.props;
    const { hovers } = this.state;
    const activeData = this.props.activeData || {};
    return (
      <div className="ccs-com-infolist">
        {dataSource.map(item => {
          const isActive = activeData[rowKey] && item[rowKey] === activeData[rowKey];
          const isHover = hovers[item[rowKey]];
          const img = isHover || isActive ? activeBgImg : bgImg;
          return (
            <div
              key={item[rowKey]}
              onMouseOver={() => this.onMouseOver(item)}
              onMouseOut={() => this.onMouseOut(item)}
              onClick={e => onClick(item, e)}
              className={cls('ccs-com-infolist-item-wrapper', { 'ccs-com-infolist-item-active': isActive })}
              style={{ backgroundImage: `url(${img})` }}
            >
              {this.props.renderItem(item, isActive, isHover)}
            </div>
          );
        })}
      </div>
    );
  }
}

export default InfoList;
