import React, { Component } from 'react';
import PropTypes from 'prop-types';
import cls from 'classnames';
import { StdTable } from 'amos-designer';

/**
 * 表格列表
 *
 * @class TableList
 * @extends {Component}
 */
class TableList extends Component {

  static propTypes = {
    dataSource: PropTypes.array,
    columns: PropTypes.array,
    hideHeader: PropTypes.bool,
    rowKey: PropTypes.string
  };

  static defaultProps = {

  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }

  render() {
    const { dataSource, columns, hideHeader, rowKey } = this.props;
    return (
      <div className={cls('ccs-comtablelist', { 'ccs-comtablelist-hideheader': hideHeader })}>
        <StdTable
          columns={columns}
          rowKey={rowKey}
          dataSource={
            dataSource.length > 0 ? dataSource :
              Array.from({ length: 10 }, (v,k) => ({ [rowKey]: v })) }
          pagination={false}
        />
      </div>
    );
  }
}

export default TableList;
