
import moment from 'moment';


// 获取今天天的开始结束时间

export default {

  // 获取今天天的开始结束时间
  getToday() {
    let date = {};
    date.beginDate = moment().startOf('day').format('YYYY-MM-DD HH:mm:ss');
    date.endDate =  moment().endOf('day').format('YYYY-MM-DD HH:mm:ss');
    return date;
  },

  // 获取最近三天开始结束时间
  getThreeday(){
    let date = {};
    date.beginDate = moment().subtract('days', 3).startOf('day').format('YYYY-MM-DD');
    date.endDate =  moment().endOf('day').format('YYYY-MM-DD');
    return date;
  },

  // 获取昨天
  getYesterday(){
    let date = {};
    date.beginDate = moment().subtract('days', 1).startOf('day').format('YYYY-MM-DD');
    date.endDate = moment().subtract('days', 1).startOf('day').format('YYYY-MM-DD');
    return date;
  },

  // 获取本月的开始结束时间
  gettCurrMonthDays() {
    let date = {};
    date.beginDate = moment().startOf('month').format('YYYY-MM-DD HH:mm:ss');
    date.endDate =  moment().endOf('month').format('YYYY-MM-DD HH:mm:ss');
    return date;
  },

  // 获取上一个月的开始结束时间
  getLastMonthDays(){
    let date = {};
    date.beginDate = moment().subtract('month', 1).startOf('month').format('YYYY-MM-DD HH:mm:ss');
    date.endDate = moment().subtract('month', 1).endOf('month').format('YYYY-MM-DD HH:mm:ss');
    return date;
  },
  // 获取当前周的开始结束时间
  getCurrWeekDays(){
    let date = {};
    date.beginDate = moment().startOf('isoWeek').format('YYYY-MM-DD HH:mm:ss'); // 周一日期
    date.endDate = moment().endOf('isoWeek').format('YYYY-MM-DD HH:mm:ss') ;// 周日日期
    return date;
  },
  // 获取上一周的开始结束时间
  getLastWeekDays(){
    let date = {};
    date.beginDate = moment().week(moment().week() - 1).startOf('isoWeek').format('YYYY-MM-DD HH:mm:ss');
    date.endDate = moment().week(moment().week() - 1).endOf('isoWeek').format('YYYY-MM-DD HH:mm:ss');
    return date;
  },

  // 获取最近七天的开始结束时间
  getLast7Days(){
    let date = {};
    date.beginDate = moment().subtract('days', 7).startOf('day').format('YYYY-MM-DD');
    date.endDate = moment().endOf('day').format('YYYY-MM-DD');
    return date;
  },
  // 获取最近30天的开始结束时间
  getLast30Days(){
    let date = {};
    date.beginDate = moment().subtract('days', 30).startOf('day').format('YYYY-MM-DD');
    date.endDate = moment().endOf('day').format('YYYY-MM-DD');
    return date;
  },

  // 获取最近30天的开始结束时间
  getLast6MonthDays(){
    let date = {};
    date.beginDate = moment().subtract('months', 6).startOf('day').format('YYYY-MM-DD');
    moment().subtract('days', 30).startOf('day').format('YYYY-MM-DD');
    date.endDate = moment().endOf('day').format('YYYY-MM-DD');
    return date;
  },

  // 获取最近12月开始结束时间
  getLast12MonthDays (){
    let date = {};
    date.beginDate = moment().year(moment().year()-1).startOf('day').format('YYYY-MM-DD');
    date.endDate = moment().endOf('day').format('YYYY-MM-DD');
    return date;
  },

  // 获取今年的开始结束时间
  getThisYearDays(){
    let date = {};
    date.beginDate = moment().startOf('year').format('YYYY-MM-DD HH:mm:ss');
    date.endDate = moment().endOf('year').format('YYYY-MM-DD HH:mm:ss');
    return date;
  },

  // 获取今年的开始时间、当前时间
  getCurrentYearDays(){
    let date = {};
    date.beginDate = moment().startOf('year').format('YYYY-MM-DD HH:mm:ss');
    date.endDate = moment().endOf('day').format('YYYY-MM-DD HH:mm:ss');
    return date;
  },

  // 获取去年的开始结束时间
  getLastYearDays(){
    let date = {};
    date.beginDate = moment().year(moment().year()-1).startOf('year').format('YYYY-MM-DD HH:mm:ss');
    date.endDate = moment().year(moment().year()-1).endOf('year').format('YYYY-MM-DD HH:mm:ss');
    return date;
  },

  // 获取两个日期之间的所有日期，格式：MM-DD
  enumerateDaysBetweenDates(startDate, endDate) {
    let daysList = [];
    const start = moment(startDate);
    const end = moment(endDate);
    const day = end.diff(start, 'days');
    daysList.push(start.format('MM-DD'));
    for (let i = 1; i <= day; i++) {
      daysList.push(start.add(1, 'days').format('MM-DD'));
    }
    return daysList;
  }
};
