import { request, gateWay } from '@gm/graphmod-utils';

const {
  commonGet,
  formatUrl,
  completePrefix
} = request;

export const UrlConsts = {
  vedioPageListUrl: () => completePrefix()(gateWay.ccs, 'fire-video/relation-list?current={page}&size={size}&relationId={fireEquipmentMrid}'), // 视频 get
  attendanceSttisticsListUrl: () => completePrefix()(gateWay.ccs, '/fire-vehicle/{stationCode}/list') // 车辆 get
};

/**
 * 监控视屏分页列表
 * @param {*} page
 * @param {*} size
 * @param {*} filter 过滤条件
 */
export const videoPageListAction = (page, size, fireEquipmentMrid) => {
  return commonGet(formatUrl(UrlConsts.vedioPageListUrl(), { page, size, fireEquipmentMrid }));
};

/**
 * 车辆list
 */
export const attendanceSttisticsListAction = (stationCode) => {
  return commonGet(formatUrl(UrlConsts.attendanceSttisticsListUrl(), { stationCode }));
};
