import React, { Component } from 'react';
import PropTypes from 'prop-types';

/**
 * 灾情信息-下侧切换按钮
 *
 * @class TabsMenus
 * @extends {Component}
 */
class TabsMenus extends Component {

  static propTypes = {
    list: PropTypes.array,
    onClick: PropTypes.func
  };

  static defaultProps = {
    list: []
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }

  render() {
    const { list, onClick } = this.props;
    return (
      <ul className="ccs-disaster-tablist">
        {
          list.map(e => (
            <div className="ccs-disaster-tablist-item" key={e.key} onClick={() => onClick(e)}>
              <img src={e.img} alt="" />
              <p>{e.name}</p>
            </div>
          ))
        }
      </ul>
    );
  }
}

export default TabsMenus;
