import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connectGlobalPage } from '@gm/graphmod-common';
import { MQTTProvider } from 'amos-mqtt';
import { message, eventConsts } from './../../eventConsts';
import DisasterLeft from './DisasterLeft';
import DisasterRight from './DisasterRight';


/**
 * 灾情信息
 *
 * @class Disaster
 * @extends {Component}
 */
@connectGlobalPage({
  testDataConfig: {
  }
})
class Disaster extends Component {
  static propTypes = {
    dataConfig: PropTypes.object
  };

  constructor(props) {
    super(props);
    this.state = {
      alarm: message.getStorageData(eventConsts.FIRE_ALARM_CHANGE) || { id: '' },
      // alarm: { sequenceNbr: '1422102390512865282', alarmTypeCode: '230' },
      alarmDetails: {}
    };
  }

  componentDidMount() {
    message.storageSubscribe(eventConsts.STATION_CODE, (data) => {
      this.setState({ alarm: data || {} });
    });
  }

  render() {
    const { alarm } = this.state;
    return (
      <div className="ccs-disaster">
        <DisasterLeft key={`${alarm.id}left`} alarm={alarm} {...this.props} />
        <DisasterRight key={`${alarm.id}right`} alarm={alarm} {...this.props} />
      </div>
    );
  }
}

export default Disaster;
