import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { TableList, ScreenCard } from './../../../common';
import {
  attendanceSttisticsAction,
  attendanceSttisticsListAction
} from './../../api';
/**
 * 到场力量统计
 *
 * @class AttendanceSttistics
 * @extends {Component}
 */
class AttendanceSttistics extends Component {

  static propTypes = {
    alarm: PropTypes.object
  };

  static defaultProps = {
    alarm: {}
  };

  constructor(props) {
    super(props);
    this.state = {
      data: [],
      dataSource: []
    };
  }

  componentDidMount() {
    this.requestData();
  }

  requestData = () => {
    const { alarm } = this.props;
    // attendanceSttisticsAction(alarm.id).then(d => {
    //   this.setState({ data: d || [] });
    // });
    attendanceSttisticsListAction(alarm.stationCode || '').then(d => {
      const data = [
        {
          key: 'useNum',
          label: '调动人力',
          unit: '人',
          value: '0'
        },
        {
          key: 'carNum',
          label: '调动车辆',
          unit: '辆',
          value: d.length || 0
        }
      ];
      this.setState({ dataSource: d || [], data });
    });
  }

  renderColumns = () => {
    return [
      { dataIndex: 'name', title: '车辆名称', width: '39%' },
      { dataIndex: 'type', title: '车辆类型', width: '30%' },
      { dataIndex: 'number', title: '车牌号', width: '30%' }
    ];
  }

  render() {
    const { data, dataSource } = this.state;
    return (
      <ScreenCard title="到场力量统计"  wrapperClassName="ccs-disaster-attendancesttistics">
        <div className="ccs-disaster-attendancesttistics-content">
          {
            data.map(e => (
              <div className="ccs-disaster-attendancesttistics-item" key={e.key}>
                <div className="ccs-disaster-attendancesttistics-value">
                  {e.value}
                  <span className="ccs-disaster-attendancesttistics-unit">{e.unit}</span>
                </div>
                <div className="ccs-disaster-attendancesttistics-name">
                  {e.label}
                </div>
              </div>
            ))
          }
        </div>
        <div className="ccs-disaster-attendancesttistics-table ccs-scrollbar">
          <TableList
            columns={this.renderColumns()}
            rowKey="sequenceNbr"
            dataSource={dataSource}
          />
        </div>
      </ScreenCard>
    );
  }
}

export default AttendanceSttistics;
