import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { ScreenCard } from './../../../common';
import { fireSiteSttisticsAction } from './../../../api';
/**
 * 火场现场数据统计
 *
 * @class FireSiteSttistics
 * @extends {Component}
 */
class FireSiteSttistics extends Component {

  static propTypes = {
    alarm: PropTypes.object
  };

  static defaultProps = {
    alarm: {}
  };

  constructor(props) {
    super(props);
    this.state = {
      data: []
    };
  }

  componentDidMount() {
    this.requestData();
  }

  requestData = () => {
    // const { alarm } = this.props;
    // fireSiteSttisticsAction(alarm.id).then(d => {
    //   this.setState({ data: d || [] });
    // });
    const data = [
      {
        key: 'trappedNum',
        label: '被困人数',
        unit: null,
        value: 2
      },
      {
        key: 'casualtiesNum',
        label: '伤亡人数',
        unit: null,
        value: 0
      }
    ];

    this.setState({
      data
    });
  }

  render() {
    const { data } = this.state;
    return (
      <ScreenCard title="火场现场数据统计" wrapperClassName="ccs-disaster-sitesttistics">
        <div className="ccs-disaster-sitesttistics-content">
          {
            data.map(e => (
              <div className="ccs-disaster-sitesttistics-item" key={e.key}>
                <div className="ccs-disaster-sitesttistics-value">
                  {e.value}
                </div>
                <div className="ccs-disaster-sitesttistics-name">
                  {e.label}
                </div>
              </div>
            ))
          }
        </div>
      </ScreenCard>
    );
  }
}

export default FireSiteSttistics;
