import React, { Component } from 'react';
import { VideoMatrix, VideoMatrixNew } from '@gm/graphmod-common';
import { videoPageListAction,getVideoUrl } from './../../api';
/**
 * 视频信息
 *
 * @class VideoInfo
 * @extends {Component}
 */
class VideoInfo extends Component {
  constructor(props) {
    super(props);
    this.state = {
      page: 1,
      size: 4,
      total: 0,
      videos: []
    };
  }

  componentDidMount() {
    this.onRequestVedios();
  }

  onRequestVedios = () => {
    const { alarm } = this.props;
    const { page, size } = this.state;
    // videoPageListAction(page, size, alarm.id).then(resp => {
    //   const { records, total } = resp;
    //   const date =  records.map((item) => {
    //     let json = { ...item };
    //     json.key = item.id;
    //     json.vedioId = item.code;
    //     json.token = item.token;
    //     json.liveVideoHost = item.url;
    //     return json;
    //   });
    //   this.setState({ videos: date, total: Number(total) });
    // });
    let all = [
      {
        address: '站围墙东北侧182',
        code: 'AFSP0002',
        id: '1',
        location: '复龙换流站',
        name: '站围墙东北侧182#',
        presetPosition: null,
        specificId: null,
        token: 'hk156--1',
        url: 'http://1011.hlsplay.aodianyun.com/demo/game.flv'
      },
      {
        address: '站围墙东北侧182',
        code: 'AFSP0002',
        id: '2',
        location: '金华换流站',
        name: '站围墙东北侧182#',
        presetPosition: null,
        specificId: null,
        token: 'hk156--1',
        url: 'http://1011.hlsplay.aodianyun.com/demo/game.flv'
      }
    ];
    this.setState({ videos: all });
  }


  onRefresh = (vedio) => {
    const { videos } = this.state;
    videos.forEach(e => {
      if (e.key === vedio.id) {
        getVideoUrl(vedio.code).then(res => {
          if (res) {
            e.liveVideoHost = res;
          }
        });
      }
    });
    this.setState({
      videos
    });
  };


  handlePageChange = (page, size) => {
    this.setState({ videos: [], page, size }, this.onRequestVedios);
  }

  render() {
    const { page, size, videos, total } = this.state;
    return (
      <div className="ccs-disaster-dynamicinfo">
        <div className="ccs-disaster-dynamicinfo-video-wrapper">
          <div className="ccs-disaster-video-header">
            <VideoMatrixNew.Pagination page={page} size={size} onPageChange={this.handlePageChange} total={total} />
          </div>
          <div className="ccs-disaster-video-content">
            <VideoMatrixNew
              videos={videos}
              matrix={size}
              title={(e) => `${e.name || ''}-${e.address || ''}`}
              dataConfig={{ videoMore: false }}
              onRefresh={this.onRefresh}
            />
          </div>
        </div>
      </div>
    );
  }
}

export default VideoInfo;
