import { request, gateWay } from '@gm/graphmod-utils';

const { completePrefix } = request;

const defaultBindglobals = [
  { key: 'stationCode', name: 'stationCode' },
  { key: 'sourceId', name: 'sourceId', require: false }
];

function mapConfig({ sourceLat = '', sourceLng = '' }) {
  return {
    // 跑马灯配置
    marqueeConfig: {
      style: { width: 'calc(100% - 384px)' },
      mqttOption: { // 跑马灯消息配置
        topic: '/fdasfas/daf' // 跑马灯消息主题
      },
      listConfig: { // 跑马灯消息列表接口url
        api: completePrefix()(gateWay.ccs, 'fire-equipment-signal-log/today/list'), bindglobals: defaultBindglobals
      },
      format: '{createDate} {stationName}{location}{signalTypeName}' // 跑马灯消息内容展示格式
    },
    // 地图信息板配置
    infoAreaConfig: {
      left: { style: { width: 344, top: 6, left: 6, height: 'calc(100% - 12px)' }, page: 'a1' },
      right: { style: { width: 305, top: 52, right: 75 }, page: 'a2' },
      bottom: {}
    },
    // 右侧工具栏配置
    toolbarConfig: [
      // { key: '坐标拾取', title: '坐标拾取', img: `./upload/sfcc/commond/坐标拾取.png`, type: 'switch', defaultValue: false, method: 'latLngGrab' },
      { key: '清除', title: '清除', img: `./upload/sfcc/commond/清除.png`, type: 'click', method: 'clearMap' },
      { key: '图标说明', title: '图标说明', img: `./upload/sfcc/commond/图标说明.png`, type: 'page', defaultValue: false, method: 'openIconDescr' },
      { key: '复位', title: '复位', img: `./upload/sfcc/commond/回到首页.png`, type: 'click', method: 'switchToAlarmPoint' }
    ],
    // 底部资源栏配置
    resourceConfig: [
      {
        key: '消防建筑', title: '消防建筑', img: `./upload/sfcc/common/建筑.png`, mqttOption: { topic: '/sfcc/tcb_alertInfo' },
        listConfig: {
          height: '100%',
          defaultActive: true,
          hideClose: true,
          api: completePrefix()(gateWay.ccs, '/fire-building/{stationCode}/page?buildingType=building'),
          method: 'get', pageName: 'current', sizeName: 'size', isPage: true, bindglobals: defaultBindglobals,
          rowKey: 'id', title: 'seg&{"content": "{name}"}',
          filters: [{ placeholder: '搜索', name: 'name', type: 'input' }],
          info: [
            {
              name: '建筑地址', value: '{position}', hideLabel: true, width: '100%',
              icon: 'addressIcon&{"icon": "./upload/sfcc/commond/地址.png", "unicon": "./upload/sfcc/commond/地址_无经纬度.png"}'
            }, {
              name: '消防设备', value: '{equipmentNumber}', hideLabel: false, width: '100%', icon: './upload/sfcc/commond/单位.png'
            }
          ]
        },
        mapConfig: { id: '消防建筑' }
      },
      {
        key: '消防水源', title: '消防水源', img: `./upload/sfcc/common/水源.png`,
        listConfig: {
          height: '100%',
          hideClose: true,
          api: completePrefix()(gateWay.ccs, '/fire-water/{stationCode}/page'),
          method: 'get', pageName: 'current', sizeName: 'size', isPage: true, bindglobals: defaultBindglobals,
          rowKey: 'id', title: 'seg&{"content": "{name}"}',
          filters: [{ placeholder: '搜索', name: 'name', type: 'input' }],
          info: [
            {
              name: '水源位置', value: '{position}', hideLabel: true, width: '100%',
              icon: 'addressIcon&{"icon": "./upload/sfcc/commond/地址.png", "unicon": "./upload/sfcc/commond/地址_无经纬度.png"}'
            },
            { name: '当前水位 ', value: '{waterLevel}', icon: `./upload/sfcc/commond/单位.png`, hideLabel: false, width: '100%' }
          ]
        },
        mapConfig: { id: '消防水源' }
      },
      {
        key: '消防车辆', title: '消防车辆', img: `./upload/sfcc/common/车辆.png`,
        listConfig: {
          height: '100%',
          hideClose: true,
          api: completePrefix()(gateWay.ccs, '/fire-vehicle/{stationCode}/page'),
          method: 'get', pageName: 'current', sizeName: 'size', isPage: true, bindglobals: defaultBindglobals,
          rowKey: 'id', title: 'seg&{"content": "{name}"}',
          filters: [{ placeholder: '搜索', name: 'name', type: 'input' }],
          info: [
            { name: '启动状态', value: '{startState}', icon: `./upload/sfcc/commond/人员.png`, hideLabel: false, width: '100%' },
            { name: '最近启动', value: '{lastStartDate}', icon: `./upload/sfcc/commond/单位.png`, hideLabel: false, width: '100%' }
          ]
        },
        mapConfig: { id: '消防车辆' }
      },
      {
        key: '摄像头', title: '摄像头', img: `./upload/sfcc/common/摄像头.png`, mqttOption: {},
        listConfig: {
          height: '100%',
          hideClose: true,
          api: completePrefix()(gateWay.ccs, '/fire-video/{stationCode}/page'),
          method: 'get', pageName: 'current', sizeName: 'size', isPage: true, bindglobals: defaultBindglobals,
          rowKey: 'id', title: 'seg&{"content": "{name}"}',
          filters: [
            {
              displayName: '', placeholder: '全部建筑', name: 'buildingMrids', defaultValue: '', type: 'treeselect', idKey: 'treeMrids', nameKey: 'name',
              api: completePrefix()(gateWay.ccs, '/fire-building/{stationCode}/tree'), bindglobals: defaultBindglobals
            }
          ],
          info: [
            {
              name: '摄像头类型', value: '{type}', hideLabel: true, width: '100%',
              icon: `./upload/sfcc/commond/单位.png`
            },
            {
              name: '摄像头安装位置', value: '{position}', hideLabel: true, width: '100%',
              icon: 'addressIcon&{"icon": "./upload/sfcc/commond/地址.png", "unicon": "./upload/sfcc/commond/地址_无经纬度.png"}'
            }
          ]
        },
        mapConfig: { id: '摄像头' }
      }
    ],
    // 警情列表配置
    mainConfig: {
    },
    mapPointConfig: {
      '实时告警': {
        common: {
          rowKey: 'id',
          typeKey: 'signalType',
          classify: '实时告警',
          latitudeKey: 'lat',
          longitudeKey: 'lng',
          width: 40,
          height: 40,
          marker: {
            titleMarker: {
              showLevels: [5],
              props: { title: '{stationName}', background: '#1173d1', color: 'white', factor: 0 }
            }
          },
          layer: '实时告警',
          img: './upload/sfcc/common/故障.png',
          loactionDetails: 'click',
          detail: {
            click: {
              component: 'keyValueTable', props: {
                name: 'stationName',
                infos: [
                  { name: '告警类型', value: `{signalTypeName}`, labelWidth: '5em' },
                  { name: '发生时间', value: `{createDate}`, labelWidth: '5em' },
                  { name: '告警内容', labelWidth: '5em', value: `{fireEquipmentName}{fireEquipmentIndexName}` }
                ]
              }
            }
          }
        },
        items: {
          'FIREALARM': { img: './upload/sfcc/common/故障.png' }
        }
      },
      '换流站': {
        common: {
          rowKey: 'code',
          typeKey: 'safetyStatus',
          classify: '换流站',
          latitudeKey: 'lat',
          longitudeKey: 'lng',
          width: 32,
          height: 32,
          layer: '换流站',
          loactionDetails: 'click',
          marker: {
            titleMarker: {
              showLevels: [5],
              props: { title: '{name} {safetyIndex}分', background: '#1173d1', color: 'white', factor: 0 }
            }
            // normalMarker: {
            //   showLevels: [1, 2, 3, 4],
            //   props: { factor: 0 }
            // },
            // smallMarker: {
            //   showLevels: [1, 2, 3, 4],
            //   props: { width: 10, height: 10, factor: 0 }
            // }
          },
          detail: {
            click: {
              component: 'keyValueTable', props: {
                name: 'name',
                infos: [
                  { name: '今日安全指数', value: `{safetyIndex}`, labelWidth: '6.5em' },
                  { name: '今日告警数', value: `{todayAlarmTimes}`, labelWidth: '6.5em' },
                  { name: '现有隐患数', value: `{existDangerNumber}`, labelWidth: '6.5em' }
                ]
              }
            }
          }
        },
        items: {
          '1': { img: './upload/sfcc/common/1.png' },
          '2': { img: './upload/sfcc/common/2.png' },
          '3': { img: './upload/sfcc/common/3.png' },
          '4': { img: './upload/sfcc/common/4.png' }
        }
      },
      '消防建筑': {
        common: {
          rowKey: 'id',
          classify: '消防建筑',
          width: 32,
          height: 32,
          latitudeKey: 'lat',
          longitudeKey: 'lng',
          layer: '消防建筑',
          img: './upload/sfcc/common/消防建筑.png',
          marker: {
            titleMarker: {
              showLevels: [19],
              props: { title: '{name}', background: '#1173d1', color: 'white', factor: 0 }
            }
          },
          loactionDetails: 'click',
          detail: {
            click: {
              component: 'keyValueTable', props: {
                name: 'name', infos: [
                  { name: '建筑类别', value: `classify`, labelWidth: '5em' },
                  { name: '建筑编号', value: 'mrid', labelWidth: '5em' },
                  { name: '建筑层数', value: 'floorNumber', labelWidth: '5em' },
                  { name: '消防设备', value: 'equipmentNumber', labelWidth: '5em' }
                ]
              }
            }
          }
        }
      },
      '消防水源': {
        common: {
          rowKey: 'id',
          typeKey: 'type',
          classify: 'alert',
          latitudeKey: 'lat',
          longitudeKey: 'lng',
          img: './upload/sfcc/common/消火栓.png',
          marker: {
            titleMarker: {
              showLevels: [19],
              props: { title: '{name}', background: '#1173d1', color: 'white', factor: 0 }
            }
          },
          loactionDetails: 'click',
          detail: {
            click: {
              component: 'keyValueTable', props: {
                name: 'name', infos: [
                  { name: '水源类别', value: `type`, labelWidth: '5em' },
                  { name: '水源编号', value: 'mrid', labelWidth: '5em' },
                  { name: '联系人', value: 'contantPerson', labelWidth: '5em' },
                  { name: '联系电话', value: 'contantNumber', labelWidth: '5em' }
                ]
              }
            }
          },
          width: 32,
          height: 32,
          layer: '消防水源'
        },
        items: {
          '消防水池': { img: './upload/sfcc/common/消防水池.png' },
          '消防水鹤': { img: './upload/sfcc/common/消防水鹤.png' },
          '消火栓': { img: './upload/sfcc/common/消火栓.png' },
          '天然水源': { img: './upload/sfcc/common/天然水源.png' }
        }
      },
      '消防车辆': {
        common: {
          rowKey: 'id',
          classify: '消防车辆',
          latitudeKey: 'lat',
          longitudeKey: 'lng',
          img: './upload/sfcc/common/消防车.png',
          marker: {
            titleMarker: {
              showLevels: [19],
              props: { title: '{name}', background: '#1173d1', color: 'white', factor: 0 }
            }
          },
          loactionDetails: 'click',
          detail: {
            click: {
              component: 'keyValueTable', props: {
                name: 'name', infos: [
                  { name: '类别', value: `type`, labelWidth: '5em' },
                  { name: '牌号', value: 'number', labelWidth: '5em' },
                  { name: '状态', value: 'startState', labelWidth: '5em' },
                  { name: '启动时间', value: 'lastStartDate', labelWidth: '5em' }
                ]
              }
            }
          },
          width: 52,
          height: 20,
          layer: '消防车辆'
        }
      },
      '摄像头': {
        common: {
          rowKey: 'id',
          classify: '摄像头',
          latitudeKey: 'lat',
          longitudeKey: 'lng',
          img: './upload/sfcc/common/视频.png',
          width: 32,
          height: 32,
          layer: '摄像头',
          marker: {
            titleMarker: {
              showLevels: [19],
              props: { title: '{name}', background: '#1173d1', color: 'white', factor: 0 }
            }
          }
        }
      }
    },
    // 地图默认实时图层
    mapLayerConfig: [
      {
        key: '换流站', type: 'all',
        listConfig: {
          api: completePrefix()(gateWay.ccs, 'fire-station-info/list'), isPage: false, rowKey: 'code'
        },
        mapConfig: { id: '换流站' }
      },
      {
        key: 'alarmPoint', type: 'all',
        listConfig: {
          api: completePrefix()(gateWay.ccs, 'fire-equipment-signal-log/list?top=50'),
          isPage: false,
          rowKey: 'id',
          bindglobals: defaultBindglobals
        },
        mapConfig: { id: '实时告警' },
        method: 'defaultOpenTitle'
      }
    ],
    // 地图配置
    mapConfig: {
      // // 地图初始中心点经纬度
      center: {
        longitude: sourceLng || 101.5525, latitude: sourceLat || 35.3227
      },
      // // 地图初始层级
      level: 18,
      // 地图数据定位移动层级
      locationTolevel: 18,
      // 地图可以显示那些的图层
      levels: [17, 19],
      // 地图工具定位配置
      toolLocation: { img: './upload/sfcc/common/commond/point.png', width: 19, height: 33 },
      // 地图清除，清除哪些临时图层
      clearLayers: [
        '消防建筑', '消防水源', '消防车辆', '摄像头'
      ],
      // 初始化隐藏那些图层
      hideLayers: [],
      // 初始化显示哪些图层
      showLayers: [],
      // 灾圈配置
      alertCircle: {

      },
      // 聚合配置
      aggregationConfig: {
        default: false,
        layers: [
          {
            key: '电梯',
            layerName: '电梯',
            label: '电梯',
            noRest: true,
            distance: '100',  // 聚合范围 100米
            bak: [
              { maxCount: 100, img: '/upload/jcs/common/map/聚合4.png', width: 60, height: 60 },
              { minCount: 101, maxCount: 500, img: '/upload/jcs/common/map/聚合4.png', width: 65, height: 65 },
              { minCount: 501, maxCount: 1000, img: '/upload/jcs/common/map/聚合4.png', width: 70, height: 70 },
              { minCount: 1001, img: '/upload/jcs/common/map/聚合4.png', width: 80, height: 80 }
            ]
          }
        ]
      },
      // 地图点图标说明信息
      iconList: [
        {
          name: '换流站风险等级', children: [
            { name: '重大风险', img: './upload/sfcc/common/1.png', height: '28px' },
            { name: '较大风险', img: './upload/sfcc/common/2.png', height: '28px' },
            { name: '一般风险', img: './upload/sfcc/common/3.png', height: '28px' },
            { name: '低分险', img: './upload/sfcc/common/4.png', height: '28px' }
          ]
        },
        {
          name: '告警', children: [
            { name: '故障', img: './upload/sfcc/common/故障.png', height: '28px' },
            { name: '火警', img: './upload/sfcc/common/火警.png', height: '28px' },
            { name: '漏油', img: './upload/sfcc/common/漏油.png', height: '28px' },
            { name: '屏蔽', img: './upload/sfcc/common/屏蔽.png', height: '28px' }
          ]
        },
        {
          name: '水源类型', children: [
            { name: '消防水池', img: './upload/sfcc/common/消防水池.png', height: '28px' },
            { name: '消防水鹤', img: './upload/sfcc/common/消防水鹤.png', height: '28px' },
            { name: '消火栓', img: './upload/sfcc/common/消火栓.png', height: '28px' },
            { name: '天然水源', img: './upload/sfcc/common/天然水源.png', height: '28px' }
          ]
        },
        {
          name: '其他', children: [
            { name: '消防建筑', img: './upload/sfcc/common/消防建筑.png', height: '28px' },
            { name: '消防车辆', img: './upload/sfcc/common/消防车.png', height: '28px' },
            { name: '摄像头', img: './upload/sfcc/common/视频.png', height: '28px' }
          ]
        }
      ]
    }
  };
}

export default mapConfig;
