import { chainModResult } from 'amos-viz/lib/widgets/modLoader';
import Weather from './weather';
import securitySituation from './securitySituation';
import iotMonitoring from './iotMonitoring';
import riskSituation from './riskSituation';
import Map from './map';
import emergency  from './emergency';
import disposal from './rescue';
import videoMonitor from './videoMonitor';
import disaster from './disaster';

import './index.scss';
import './cssvar.scss';

const IMods = [
  ...Weather, // 天气
  ...Map, // 安全态势地图
  ...securitySituation, // 安全态势
  ...iotMonitoring, // 物联监控
  ...riskSituation, // 风险态势
  ...emergency,
  ...disposal,
  ...videoMonitor, // 视频监控
  ...disaster // 灾情信息
];

export default chainModResult(IMods).mods;
