import { request, gateWay } from '@gm/graphmod-utils';

const {
  commonGet,
  formatUrl,
  completePrefix
} = request;

export const UrlConsts = {
  iotAccessSummaryUrl: () => completePrefix()(gateWay.ccs, 'fire-equipment/iot/count'), // 物联接入汇总
  iotEquipmentListUrl: () => completePrefix()(gateWay.ccs, 'fire-equipment/station/info?stationName={stationName}'), // 站端物联设备
  faultEquipmentTop10Url: () => completePrefix()(gateWay.ccs, 'fire-equipment/count/fault/list?top=10'), // 故障设备top10
  alarmCountUrl: () => completePrefix()(gateWay.ccs, 'fire-signal-day-statistics/alarm/count'), // 警情信息统计
  lastYearAlarmUrl: () => completePrefix()(gateWay.ccs, 'statistics/station/lastYearAlarm'), // 近一年警情统计
  alarmTrendUrl: () => completePrefix()(gateWay.ccs, 'fire-signal-day-statistics/alarm/trend?beginData={beginDate}&endData={endDate}'), // 警情变化趋势
  alarmPercentUrl: () => completePrefix()(gateWay.ccs, 'fire-signal-day-statistics/alarm/percent?beginData={beginDate}&endData={endDate}'), // 警情类型占比
  signalEquipmentTop50Url: () => completePrefix()(gateWay.ccs, 'fire-equipment-signal-log/list?top=50') // 警情动态
};

/**
 * 物联接入汇总
 * @returns
 */
export function iotAccessSummaryAction() {
  return commonGet(formatUrl(UrlConsts.iotAccessSummaryUrl()));
}

/**
 * 站端物联设备
 * @returns
 */
export const iotEquipmentListAction = (stationName) => {
  return commonGet(formatUrl(UrlConsts.iotEquipmentListUrl(), { stationName }));
};

/**
 * 近30日告警隐患
 * @returns
 */
export const faultEquipmentTop10Action = () => {
  return commonGet(formatUrl(UrlConsts.faultEquipmentTop10Url()));
};

/**
 * 警情信息统计
 * @returns
 */
export const alarmCountAction = () => {
  return commonGet(formatUrl(UrlConsts.alarmCountUrl()));
};

/**
 * 近一年警情统计
 * @returns
 */
export const lastYearAlarmAction = () => {
  return commonGet(formatUrl(UrlConsts.lastYearAlarmUrl()));
};

/**
 * 警情变化趋势
 * @returns
 */
export const alarmTrendAction = (beginDate, endDate) => {
  return commonGet(formatUrl(UrlConsts.alarmTrendUrl(), { beginDate, endDate }));
};

/**
 * 警情类型占比
 * @returns
 */
export const alarmPercentAction = (beginDate, endDate) => {
  return commonGet(formatUrl(UrlConsts.alarmPercentUrl(), { beginDate, endDate } ));
};

/**
 * 警情动态
 * @returns
 */
export const signalEquipmentTop50Action = () => {
  return commonGet(formatUrl(UrlConsts.signalEquipmentTop50Url()));
};
