import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { IFrame, Icon } from 'amos-framework';


class View3d extends Component {
  constructor(props) {
    super(props);
  }

  render() {
    const { onClose, url } = this.props;
    return (
      <div className="ccs-view-3d">
        <Icon icon="cross" style={{ fontSize: 20, color: 'red' }} onClick={onClose} />
        <IFrame
          width="100%"
          height="100%"
          allowFullScreen
          style={{ zIndex: 1 }}
          url={url}
        />
      </div>
    );
  }
}

View3d.propTypes = {
  onClose: PropTypes.func,
  url: PropTypes.string
};

export default View3d;
