import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Tabs } from 'amos-framework';
import RescueObject from './object/ObjectRescue';
import BuildObject from './build';
import './index.scss';

const { TabList, Tab, TabPanel } = Tabs;

const fireTypesData = [
  { key: 'generalFire', code: '229', name: '一般火灾', isUnit: true, isAire: false },
  { key: 'aircraftRescue', code: '230', name: '航空器救援', isUnit: false, isAire: true },
  { key: 'emergency', code: '235', name: '突发事件', isUnit: true, isAire: true },
  { key: 'oilSpillProtection', code: '237', name: '漏油保障', isUnit: false, isAire: true },
  { key: 'specialAircraftSupport', code: '238', name: '专机保障', isUnit: false, isAire: true },
  { key: '120', code: '1214', name: '120急救', isUnit: true, isAire: true },
  { key: 'other', code: '242', name: '其他', isUnit: true, isAire: false }
];
/**
 * 处置对象
 *
 * @class Disposal
 * @extends {Component}
 */
class Disposal extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  render() {
    const { alarm } = this.props;
    const typeData = fireTypesData.find(e => e.code === alarm.alarmTypeCode) || {};
    return (
      <div className="ccs-box" style={{ padding: '0 10px 10px 10px' }}>
        <Tabs className="ccs-tabs" >
          <TabList>
            <Tab>救援对象</Tab>
            <Tab>建（构）筑信息</Tab>
          </TabList>
          <TabPanel>
            <RescueObject />
          </TabPanel>
          <TabPanel>
            <BuildObject />
          </TabPanel>
        </Tabs>
      </div>
    );
  }
}

Disposal.propTypes = {
  alarm: PropTypes.object
};

export default Disposal;
