import { request, gateWay } from '@gm/graphmod-utils';

const {
  commonGet,
  formatUrl,
  completePrefix
} = request;

export const UrlConsts = {
  getStationInfoUrl: () => completePrefix()(gateWay.ccs, 'fire-station-info/{stationCode}/detail'), // 换流站详情
  alarmDangerLineUrl: () => completePrefix()(gateWay.ccs, 'statistics/alarmAndDangerTrend?beginDate={beginDate}&endDate={endDate}'), // 近7日告警隐患
  getRiskRiseUprateUrl: () => completePrefix()(gateWay.ccs, 'fire-rpn-change-log/{stationCode}/riseUp'), // 风险读(rpn)上升百分比
  queryRiskSourceMatrixUrl: () => completePrefix()(gateWay.ccs, 'fire-fmea-statistics/{stationCode}/list'), // 发生率/严重度矩阵
  queryRiskSourceRpnCountUrl: () => completePrefix()(gateWay.ccs, 'fire-risk-source/{stationCode}/list?top=10'), // 风险度(RPN) TOP10
  getRegionAreaRpnUrl: () => completePrefix()(gateWay.ccs, 'fire-risk-source/{stationCode}/list') // 换流站风险态势图
};

/**
 * 换流站详情
 * @returns
 */
export function getStationInfoAction(stationCode) {
  return commonGet(formatUrl(UrlConsts.getStationInfoUrl(), { stationCode }));
}

/**
 * 近7日告警隐患
 * @returns
 */
export const alarmDangerLineAction = (beginDate, endDate) => {
  return commonGet(formatUrl(UrlConsts.alarmDangerLineUrl(), { beginDate, endDate }));
};

/**
 * 风险读(rpn)上升百分比
 * @returns
 */
export const getRiskRiseUprateAction = (stationCode) => {
  return commonGet(formatUrl(UrlConsts.getRiskRiseUprateUrl(), { stationCode }));
};

/**
 * 发生率/严重度矩阵
 * @returns
 */
export const queryRiskSourceMatrixAction = (stationCode) => {
  return commonGet(formatUrl(UrlConsts.queryRiskSourceMatrixUrl(), { stationCode }));
};

/**
 * 风险度(RPN) TOP10
 * @returns
 */
export const queryRiskSourceRpnCountAction = (stationCode) => {
  return commonGet(formatUrl(UrlConsts.queryRiskSourceRpnCountUrl(), { stationCode }));
};


/**
 * 换流站风险态势图
 * @returns
 */
export const getRegionAreaRpnAction = (stationCode) => {
  return commonGet(formatUrl(UrlConsts.getRegionAreaRpnUrl(), { stationCode }));
};
