import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Popover } from 'amos-framework';
import { TableList, ScreenCard, withSubscribeMQTT } from './../../common';
import {
  alarmDangerListAction
} from './../api';

/**
 * 告警隐患列表
 *
 * @class AlarmDangerList
 * @extends {Component}
 */
@withSubscribeMQTT({ topic: 'power' })
class AlarmDangerList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      alarmDangerListData: []
    };
  }

  componentDidMount() {
    this.onRequest();
  }

  componentDidUpdate(prevProps, prevState) {
    if (this.props.messageFlag !== prevProps.messageFlag) {
      this.onRequest();
    }
  }

  onRequest = () => {
    alarmDangerListAction(2).then(d => {
      this.setState({ alarmDangerListData: d || [] });
    });
  }

  AlarmDangerListColumns = () => {
    return [
      // eslint-disable-next-line max-len
      { dataIndex: 'name', title: '换流站名称', render: (text) => <Popover content={text} direction="down"> <div className="ccs-security-longtext">{text}</div></Popover> },
      { dataIndex: 'todayAlarmTimes', title: '今日告警' },
      { dataIndex: 'existDangerNumber', title: '现有隐患' }
    ];
  }

  render() {
    const { alarmDangerListData } = this.state;
    return (
      <ScreenCard title="换流站告警隐患">
        <TableList
          columns={this.AlarmDangerListColumns()}
          rowKey="id"
          dataSource={alarmDangerListData}
        />
      </ScreenCard>
    );
  }
}

AlarmDangerList.propTypes = {
  messageFlag: PropTypes.number
};

export default AlarmDangerList;
