import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Popover } from 'amos-framework';
import { TableList, ScreenCard, withSubscribeMQTT } from './../../common';

import {
  todaySecurityRankingAction
} from './../api';

/**
 * 今日安全指数排名
 * @class TodaySecurityRanking
 * @extends {Component}
 */
@withSubscribeMQTT({ topic: 'alertNotice' })
class TodaySecurityRanking extends Component {
  constructor(props) {
    super(props);
    this.state = {
      todaySecurityRankingData: []
    };
  }

  componentDidMount() {
    this.onRequest();
  }

  componentDidUpdate(prevProps, prevState) {
    if (this.props.messageFlag !== prevProps.messageFlag) {
      this.onRequest();
    }
  }

  onRequest = () => {
    todaySecurityRankingAction(1).then(d => {
      this.setState({ todaySecurityRankingData: d || [] });
    });
  }

  TodaySecurityRankingColumns = () => {
    return [
      { dataIndex: 'signalType', title: '排名', width: '20%', render: (text, record, index) => `${index + 1}` },
      // eslint-disable-next-line max-len
      { dataIndex: 'name', title: '名称', render: (text) =><Popover content={text} direction="down"> <div className="ccs-security-longtext">{text}</div></Popover> },
      { dataIndex: 'safetyIndex', title: '安全指数' }
    ];
  }

  render() {
    const { todaySecurityRankingData } = this.state;
    return (
      <ScreenCard title="今日安全指数排名">
        <TableList
          columns={this.TodaySecurityRankingColumns()}
          rowKey="id"
          dataSource={todaySecurityRankingData}
        />
      </ScreenCard>
    );
  }
}

TodaySecurityRanking.propTypes = {
  messageFlag: PropTypes.number
};

export default TodaySecurityRanking;
