/* eslint-disable no-magic-numbers */
import React, { Component } from 'react';
import PropTypes from 'prop-types';


const arcWidth = 56;
const menuWidth = 0.657;
const marginBottom = 0.09;
const interval = 0.08;
const arc = 46;
/**
 * 菜单背景
 *
 * @class MenusBgCanvas
 * @extends {Component}
 */
class MenusBgCanvas extends Component {

  static propTypes = {
    type: PropTypes.string
  };

  static defaultProps = {

  };

  constructor(props) {
    super(props);
    this.state = {
      width: 0,
      height: 0
    };
  }

  componentDidMount() {
    this.onAnimation();
  }

  drawMainMenus = () => {
    const leftCtx = this.canvas.getContext('2d');
    const rightCtx = this.canvas.getContext('2d');
    leftCtx.save();
    leftCtx.beginPath();
    leftCtx.translate(0.5, 0.5);
    leftCtx.shadowBlur = 8;
    leftCtx.shadowOffsetX = 0;
    leftCtx.shadowOffsetY = 0;
    leftCtx.shadowColor = '#4DAAE0';
    leftCtx.lineCap = 'round';
    leftCtx.lineJoin = 'round';
    let _leftH = parseInt(this.height - this.height * (marginBottom + interval));
    leftCtx.moveTo(
      this.width - this.width * menuWidth + arcWidth,
      _leftH
    );
    leftCtx.arcTo(
      0 + arcWidth,
      _leftH,
      0,
      0,
      arc
    );
    leftCtx.lineTo(0, 0);
    let gnt1 = leftCtx.createLinearGradient(0, 0, this.width - this.width * menuWidth + arcWidth, _leftH);
    gnt1.addColorStop(0, '#5fbbf1');
    gnt1.addColorStop(this.start, '#5fbbf1');
    gnt1.addColorStop(this.start + 0.08, 'white');
    gnt1.addColorStop(this.start + 0.16, '#5fbbf1');
    gnt1.addColorStop(1, '#5fbbf1');
    leftCtx.strokeStyle = gnt1;
    leftCtx.lineWidth = 1;
    leftCtx.stroke();
    leftCtx.restore();

    rightCtx.save();
    rightCtx.beginPath();
    rightCtx.translate(0.5, 0.5);
    rightCtx.shadowBlur = 8;
    rightCtx.shadowOffsetX = 0;
    rightCtx.shadowOffsetY = 0;
    rightCtx.shadowColor = '#4DAAE0';
    rightCtx.lineCap = 'round';
    rightCtx.lineJoin = 'round';
    let _rightH = parseInt(this.height - this.height * marginBottom);
    rightCtx.moveTo(
      this.width,
      _rightH
    );
    rightCtx.arcTo(
      this.width - this.width * menuWidth + arcWidth,
      _rightH,
      this.width - this.width * menuWidth,
      0,
      arc
    );
    rightCtx.lineTo(this.width - this.width * menuWidth, 0);
    let gnt2 = rightCtx.createLinearGradient(this.width - this.width * menuWidth, 0, this.width, _rightH);
    gnt2.addColorStop(0, '#5fbbf1');
    gnt2.addColorStop(this.start, '#5fbbf1');
    gnt2.addColorStop(this.start + 0.08, 'white');
    gnt2.addColorStop(this.start + 0.16, '#5fbbf1');
    gnt2.addColorStop(1, '#5fbbf1');
    rightCtx.strokeStyle = gnt2;
    rightCtx.lineWidth = 1;
    rightCtx.stroke();
    rightCtx.restore();
  }

  drawSubMenus = () => {

    const leftCtx = this.canvas.getContext('2d');
    const rightCtx = this.canvas.getContext('2d');
    leftCtx.save();
    leftCtx.beginPath();
    leftCtx.translate(0.5, 0.5);
    leftCtx.shadowBlur = 8;
    leftCtx.shadowOffsetX = 0;
    leftCtx.shadowOffsetY = 0;
    leftCtx.shadowColor = '#4DAAE0';
    leftCtx.lineCap = 'round';
    leftCtx.lineJoin = 'round';
    let _leftH = parseInt(this.height - this.height * marginBottom);
    leftCtx.moveTo(
      this.width * menuWidth,
      0
    );
    leftCtx.arcTo(
      this.width * menuWidth - arcWidth,
      _leftH,
      0,
      _leftH,
      arc
    );
    leftCtx.lineTo(0, _leftH);
    let gnt1 = leftCtx.createLinearGradient(0, _leftH, this.width * menuWidth, 0);
    gnt1.addColorStop(0, '#5fbbf1');
    gnt1.addColorStop(this.start, '#5fbbf1');
    gnt1.addColorStop(this.start + 0.08, 'white');
    gnt1.addColorStop(this.start + 0.16, '#5fbbf1');
    gnt1.addColorStop(1, '#5fbbf1');
    leftCtx.strokeStyle = gnt1;
    leftCtx.lineWidth = 1;
    leftCtx.stroke();
    leftCtx.restore();


    let _h = parseInt(this.height - this.height * (marginBottom + interval));
    rightCtx.save();
    rightCtx.beginPath();
    rightCtx.translate(0.5, 0.5);
    rightCtx.shadowBlur = 8;
    rightCtx.shadowOffsetX = 0;
    rightCtx.shadowOffsetY = 0;
    rightCtx.shadowColor = '#4DAAE0';
    rightCtx.lineCap = 'round';
    rightCtx.lineJoin = 'round';
    rightCtx.moveTo(
      this.width,
      0
    );
    rightCtx.arcTo(
      this.width - arcWidth,
      _h,
      arcWidth - arc,
      _h,
      arc
    );
    rightCtx.lineTo(this.width * menuWidth - arcWidth, _h);
    let gnt2 = rightCtx.createLinearGradient(this.width * menuWidth - arcWidth, _h, this.width, 0);
    gnt2.addColorStop(0, '#5fbbf1');
    gnt2.addColorStop(this.start, '#5fbbf1');
    gnt2.addColorStop(this.start + 0.08, 'white');
    gnt2.addColorStop(this.start + 0.16, '#5fbbf1');
    gnt2.addColorStop(1, '#5fbbf1');
    rightCtx.strokeStyle = gnt2;
    rightCtx.lineWidth = 1;
    rightCtx.stroke();
    rightCtx.restore();
  }

  onAnimation = () => {
    this.ctx = this.canvas.getContext('2d');
    this.width = this.canvas.clientWidth;
    this.height = this.canvas.clientHeight;
    this.start = 0;
    const draw = () => {
      if (this.container) {
        this.canvas.width = this.container.clientWidth;
        this.canvas.height = this.container.clientHeight;
        this.width = this.canvas.width;
        this.height = this.canvas.height;
        this.ctx.clearRect(0, 0, this.width, this.height);
        if (this.props.type === 'subMenusBgCanvas') {
          this.drawSubMenus();
        } else {
          this.drawMainMenus();
        }
        this.start = this.start + 0.006;
        if (this.start > 0.76) {
          this.start = 0;
        }
      }
      window.requestAnimationFrame(draw);
    };
    window.requestAnimationFrame(draw);
  }

  render() {
    const { type } = this.props;
    return (
      <div ref={node => this.container = node} className="ccs-menus-bgcanvas">
        <canvas id={type} ref={node => this.canvas = node} width="100%" height="100%" />
      </div>
    );
  }
}

export default MenusBgCanvas;
