import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { Menu, Popover } from 'amos-framework';
import ImageConsts from '@gm/graphmod-assets';
import './btn.scss';
/**
 * 组合按钮
 *
 * @class PushBtn
 * @extends {Component}
 */
class PushBtn extends Component {

  static propTypes = {
    className: PropTypes.string,
    title: PropTypes.string,
    label: PropTypes.string, // 按钮左侧文本,
    hide: PropTypes.bool,
    disabled: PropTypes.bool, // 是否禁用按钮,
    icon: PropTypes.string, // 按钮图片,
    data: PropTypes.array // 按钮组数据
  };

  static defaultProps = {
    label: ''
  };

  constructor(props) {
    super(props);
    this.state = {
      open: false
    };
  }

  onToggle = (open) => {
    this.setState({ open });
  }

  popoverContent = () => {
    return (
      <Menu className="eb-pushbtn-menulist">
        {
          this.props.data.filter(e => !e.hide).map(m => {
            return (
              <Menu.Item
                key={m.key}
                onClick={(e) => {
                  e.stopPropagation();
                  this.onToggle(false);
                  m.click && m.click(m);
                }}
              >
                {m.icon && <img src={m.icon} alt={m.title} />} {m.title}
              </Menu.Item>
            );
          })
        }
      </Menu>
    );
  }

  render() {
    const { label, icon, disabled, title, className, hide } = this.props;
    if (hide) {
      return null;
    }
    return (
      <div
        className={
          classnames('eb-push-btn', 'eb-com-btn', className)
        }
      >
        <Popover
          contentWrapClassName="eb-pushbtn-popover"
          className="eb-pushbtn-popover-wrapper"
          content={this.popoverContent()}
          direction="down"
          triggerMode="click"
          align="right"
          open={this.state.open}
          onToggle={this.onToggle}
        >
          <div
            className="eb-pushbtn-conent"
            title={title || label}
            disabled={disabled}
          >
            <img src={icon} alt={label} />
            <div className="eb-pushbtn-arrow">
              <img src={ImageConsts.common.selecticon} alt="" />
            </div>
          </div>
        </Popover>
        {
          label &&
          <div className="eb-btn-label">{label}</div>
        }
      </div>
    );
  }
}

export default PushBtn;
