import React, { Component } from 'react';
import PropTypes from 'prop-types';
import ImageConsts from '@gm/graphmod-assets';
import './EmptyAdd.scss';
/**
 * 空数据（含添加按钮）
 *
 * @class EmptyAdd
 * @extends {Component}
 */
class EmptyAdd extends Component {

  static propTypes = {
    addtext: PropTypes.string, // 按钮文字
    tip: PropTypes.any, // 按钮提示文字
    onClick: PropTypes.func // 点击按钮
  };

  static defaultProps = {
    addtext: '新增',
    tip: '暂无数据',
    onClick(){}
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }


  render() {
    const { addtext, tip, onClick } = this.props;
    return (
      <div className="mods-empty-add">
        <div className="mods-empty-add-img">
          <img src={ImageConsts.common.addbg} alt="" />
        </div>
        <div className="mods-empty-add-btn">
          <div className="mods-empty-add-btncontent" onClick={onClick}>
            <img src={ImageConsts.common.add} alt="" /> {addtext}
          </div>
          <div className="mods-empty-add-tip">
            {tip}
          </div>
        </div>
      </div>
    );
  }
}

export default EmptyAdd;
