import React from 'react';
import PropTypes from 'prop-types';
import { FormBuilder, Connect, Cascader } from 'amos-framework';
import { request, api } from '@gm/graphmod-utils';
import './index.scss';

const { getRegion } = api;
const {
  completePrefix,
  commonGet
} = request;

const BasicForm = FormBuilder.BasicForm;
const enhanceForm = Connect.enhanceForm;


/**
 * 省市区级联选择
 * 解决省省市区级联选择地址【比较有局限性】
 * @class Cascader
 * @extends {Component}
 */
@enhanceForm
class CascaderInput extends BasicForm {
  constructor(props) {
    super(props);
    this.state = {
      data: []
    };
  }

  componentDidMount() {
    getRegion().then(resp => {
      this.setState({
        data: resp
      });
    });
  }

  render() {
    const cls = this.getClassNames('param-treeselect');
    let { value = [], onChange } = this.props;
    let {  data = [] } = this.state;
    return (
      <div className={cls}>
        <Cascader
          options={data}
          value={value}
          enableParent
          fieldNames={{ label: 'regionName', value: 'regionName', children: 'children' }}
          onChange={onChange}
          style={{ width: '100%', padding: '1px', borderRadius: '4px', minHeight: '30px' }}
          placeholder="请选择" />
      </div>
    );
  }
}


CascaderInput.propTypes = {
  datas: PropTypes.array,
  onChange: PropTypes.func
};

export default CascaderInput;
