import React from 'react';
import { MultiSelect, FormBuilder, Connect } from 'amos-framework';

const BasicForm = FormBuilder.BasicForm;
const enhanceForm = Connect.enhanceForm;
const Option = MultiSelect.Option;

/**
 * MultiSelect2
 *
 * @class MultiSelect2
 * @extends {BasicForm}
 */
@enhanceForm
class MultiSelect2 extends BasicForm {

  constructor(props) {
    super(props);
    this.state = {
      value: props.value || props.defaultValue || ''
    };
  }

  componentWillReceiveProps(nextProps) {
    if (this.props.value !== nextProps.value){
      this.setState({
        value: nextProps.value
      });
    }
  }

  handleChange = (values) => {
    this.setState({
      values
    });
    this.props.onChange && this.props.onChange(values);
  }

  render() {
    const cls = this.getClassNames('custom-mulit-select');
    const { value } = this.state;
    let { data = [] } = this.props;
    const { items = [] } = data;
    return (
      <div className={cls}>
        <MultiSelect {...this.props} tagable value={value} onChange={this.handleChange}>
          {
            items.map(d => <Option key={d.key} value={d.key}>{d.label}</Option>)
          }
        </MultiSelect>
      </div>
    );
  }
}

MultiSelect2.propTypes = {};

export default MultiSelect2;
