import React from 'react';
import { FormBuilder, Connect } from 'amos-framework';
import { Select } from 'amos-antd';
import { getPropsValue } from 'amos-designer';
import { request, gateWay } from '@gm/graphmod-utils';
import { deepCopy } from 'amos-tool';

const {
  completePrefix,
  commonGet
} = request;

const BasicForm = FormBuilder.BasicForm;
const enhanceForm = Connect.enhanceForm;
const Option = Select.Option;
/**
 * 联想输入
 * @class TextInputViewpo
 * @extends {BasicForm}
 */
@enhanceForm
class TextInputpo extends BasicForm {

  constructor(props) {
    super(props);
    this.state = {
      loaded: false,
      data: [],
      dataList: [],
      value: props.value || props.defaultValue || ''
    };
  }

  componentDidMount() {
    commonGet(completePrefix()(gateWay.jcs, this.props.url)).then(d => {
      this.props.data.items = d;
      this.setState({
        loaded: true,
        data: d || []
      });
      this.setState({ dataList: deepCopy(d || []) });
    });

  }

  // handleChange = (value) => {

  //   this.setState({
  //     value
  //   });
  //   this.props.onChange && this.props.onChange(value);
  // }

  handleChange = (value) => {

    if (value && value.includes('TextInputViewpo')) {
      this.props.onChange && this.props.onChange(value.split('TextInputViewpo')[0]);
    } else {
      this.props.onChange && this.props.onChange(value);
    }
  }

  render() {
    const { value } = this.props;
    const { data } = this.state;
    const data1 = data.filter(e => (e.name || '').toLocaleLowerCase().includes((value || '').toLocaleLowerCase()));
    return (
      <Select
        className="param-link-select"
        mode="combobox"
        value={value}
        disabled={!this.state.loaded}
        notFoundContent=""
        defaultActiveFirstOption={false}
        showArrow={false}
        filterOption={false}
        onChange={this.handleChange}
      >
        {data1.map(item => <Option key={item.id} value={`${item.name}TextInputViewpo${item.id}`}>{item.name}</Option>)}
      </Select>
    );
  }
}

TextInputpo.propTypes = {};

export default TextInputpo;
