import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { GraphIcon, BarBtnGroup, IconBtnOne } from 'amos-designer';

/**
 * 通用操作 header, 默认添加返回
 * @class OperHeader
 * @extends {Component}
 */
class OperHeader extends Component {
  static contextTypes = {
    browserHistory: PropTypes.object
  };

  handleBack = () => {
    this.context.browserHistory.goBack();
  }

  render() {
    const { className, title, children } = this.props;
    const cls = classNames('gm-comoper-header', className);
    return (
      <div className={cls}>
        <BarBtnGroup>
          <IconBtnOne
            title="返回"
            icon={<GraphIcon icon="/public/webico/function/层级-上一级.png" />}
            onClick={this.handleBack}
          />
        </BarBtnGroup>
        <span className="gm-comoper-header-title">{title}</span>
        <div className="gm-comoper-header-opers">
          {children}
        </div>
      </div>
    );
  }
}

OperHeader.propTypes = {
  className: PropTypes.string,
  title: PropTypes.string,
  children: PropTypes.node
};

export default OperHeader;
