import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import ImageConsts from '@gm/graphmod-assets';
import './detail.scss';
/**
 * 详情面板容器
 *
 * @class DetailPane
 * @extends {Component}
 */
function DetailPane(props) {
  const { children, show, onHide, className, style } = props || {};
  return (
    <div className={classnames('gm-tablepage-detail-pane', className)} style={{ display: show ? 'block' : 'none', ...style || {} }}>
      <div className="gm-tablepage-detail-pane-title">
        <span>详情</span>
        {onHide && <img src={ImageConsts.mods.right} onClick={onHide} alt="" />}
      </div>
      <div className="gm-tablepage-detail-pane-content gm-scrollbar">
        {children}
      </div>
    </div>
  );
}

DetailPane.propTypes = {
  style: PropTypes.object,
  className: PropTypes.any,
  children: PropTypes.any,
  show: PropTypes.bool,
  onHide: PropTypes.func
};

DetailPane.defaultProps = {
  onReset() { },
  onSearch() { }
};

export default DetailPane;
