import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { GraphIcon, IconButton, warningTip, IconBtnOne, BarBtnGroup } from 'amos-designer';
import { request, payload } from '@gm/graphmod-utils';
import imgStatic from '@gm/graphmod-assets';
import FileImport from './FileImport';
import './style.scss';

/**
 * 列表公共表头
 *
 * @class TableHeader
 * @extends {Component}
 */
class TableHeader extends Component {

  static propTypes = {
    onReload: PropTypes.func,
    title: PropTypes.any,
    exportProps: PropTypes.object,
    importProps: PropTypes.object,
    headerContent: PropTypes.any,
    onShowFilter: PropTypes.func,
    showFilter: PropTypes.bool,
    hideRefresh: PropTypes.bool,
    showSave: PropTypes.bool,
    showBack: PropTypes.bool,
    onTemplateDownload: PropTypes.func,
    onAdd: PropTypes.func,
    onExport: PropTypes.func,
    onSave: PropTypes.func,
    onBack: PropTypes.func,
    onEdit: PropTypes.func,
    onRefresh: PropTypes.func,
    onDelete: PropTypes.func
  };

  static defaultProps = {
    opertionsSetting: [],
    onShowFilter: {}
  };

  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

  handleVisableChange = (visible) => {
    this.setState({ visible });
  }

  handleImport = (visible) => {
    if (visible && this.state.visible) {
      warningTip('正在导入请稍后');
    } else {
      this.import && this.import.onStart();
    }
  }

  render() {
    const { title, showSave, showBack, onSave, onBack, hideRefresh, headerContent,
      importProps, exportProps, onShowFilter, showFilter, onRefresh, onExport, onTemplateDownload } = this.props;
    return (
      <div className="gm-tablepage-header">
        <div className="gm-tablepage-header-title">{title}</div>
        <div className="gm-tablepage-header-btns">
          {headerContent}
          {
            (importProps || exportProps) && <BarBtnGroup label={
              `${importProps ? '导入' : ''}${exportProps
                && importProps ? '\\' : ''} ${exportProps ? '导出' : ''}`
            }>
              {importProps &&
                <IconButton title="导入" icon={<GraphIcon icon={imgStatic.mods.import} />} onClick={() => this.handleImport(true)} />}
              {exportProps &&
                <IconButton title="导出" icon={<GraphIcon icon={imgStatic.mods.export} />} onClick={() => onExport()} />}
            </BarBtnGroup>
          }
          {importProps &&
            <FileImport
              ref={node => this.import = node}
              headers={request.compleHeaders()}
              url={importProps.api}
              onRefresh={onRefresh}
              payload={payload}
              onImport={this.handleVisableChange}
            />
          }
          {
            importProps && importProps.templateApi && <BarBtnGroup label="下载模板">
              <IconBtnOne
                title="下载模板"
                icon={<GraphIcon icon={imgStatic.mods.download} />}
                onClick={() => onTemplateDownload()}
              />
            </BarBtnGroup>
          }
          {!hideRefresh && <BarBtnGroup label="刷新">
            <IconBtnOne title="刷新" icon={<GraphIcon icon={imgStatic.mods.refresh} />} onClick={onRefresh} />
          </BarBtnGroup>}
          {showFilter &&
            <BarBtnGroup label="筛选">
              <IconBtnOne title="筛选" icon={<GraphIcon icon={imgStatic.mods.filters} />} onClick={onShowFilter} />
            </BarBtnGroup>
          }
          {
            showSave && <BarBtnGroup>
              <IconBtnOne title="保存" icon={<GraphIcon icon={imgStatic.common.save} />} onClick={onSave} />
            </BarBtnGroup>
          }
          {
            showBack && <BarBtnGroup>
              <IconBtnOne title="返回" icon={<GraphIcon icon={imgStatic.mods.exit} />} onClick={onBack} />
            </BarBtnGroup>
          }
        </div>
      </div>
    );
  }
}

export default TableHeader;
