"use strict";
Object.defineProperty(exports, "__esModule", {
  value: !0
}), exports.getCursor = exports.calcSize = exports.clearSelection = void 0;
var _amosTool = require("amos-tool"),
  clearSelection = function() {
    if (document.body.createTextRange) {
      // https://stackoverflow.com/questions/22914075/#37580789
      var e = document.body.createTextRange();
      e.collapse(), e.select()
    } else window.getSelection ? window.getSelection().empty ? window.getSelection().empty() : window.getSelection().removeAllRanges && window.getSelection().removeAllRanges() : document.selection && document.selection.empty()
  };
/**
 * 解析大小
 * @param {String|Number} val
 * @example
 *  calcSize('50%'); // { value: 50, type: 'percentage' }
 *  calcSize(60); // { value: 60, type: 'number' }
 */
exports.clearSelection = clearSelection;
var calcSize = function(e) {
  if (e) {
    if (_amosTool.utils.isNumber(e)) return {
      value: Number(e),
      type: "number"
    };
    if (e.endsWith("%")) return {
      value: Number(e.replace("%", "")),
      type: "percentage"
    }
  }
  return {
    value: 0,
    type: "number"
  }
};
/**
 * 获取 cursor
 * @param {String} type
 * @param {String} direction
 */
exports.calcSize = calcSize;
var getCursor = function(e) {
  var r = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : "horizontal",
    o = {
      cortege: {
        horizontal: {
          cursor: "col-resize"
        },
        vertical: {
          cursor: "row-resize"
        }
      },
      move: {
        horizontal: {
          cursor: "move"
        },
        vertical: {
          cursor: "move"
        }
      },
      aspect: {
        horizontal: {
          cursor: "e-resize"
        },
        vertical: {
          cursor: "w-resize"
        }
      }
    };
  return o[e] ? o[e][r] : {
    cursor: "default"
  }
};
exports.getCursor = getCursor;
