import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { Table, Pagination } from 'amos-antd';
import './table.scss';

class ComTable extends Component {
  static propTypes = {
    className: PropTypes.string,
    showSeg: PropTypes.bool,
    segName: PropTypes.string,
    rowKey: PropTypes.any,
    scroll: PropTypes.object,
    dataSource: PropTypes.array,
    columns: PropTypes.array,
    total: PropTypes.number,
    pagination: PropTypes.object,
    rowSelection: PropTypes.object,
    pageOptions: PropTypes.object,
    personTablePre: PropTypes.bool
  };

  static defaultProps = {
    segName: 'seg',
    showSeg: true,
    dataSource: [],
    columns: [],
    total: 0,
    pagination: {}
  };

  constructor(props) {
    super(props);
    this.state = {
      height: 0
    };
  }

  componentDidMount() {
    if (!this.props.personTablePre) {
      this.onResize();
      window.addEventListener('resize', this.onResize);
    }
  }

  componentDidUpdate(preProps) {
    if (preProps.dataSource.length !== this.props.dataSource.length) {
      // this.onResize();
    }
  }

  componentWillUnmount() {
    if (!this.props.personTablePre) {
      window.removeEventListener('resize', this.onResize);
    }
  }

  onResize = () => {
    const tableBody = this.table.getElementsByClassName('ant-table-tbody')[0];
    if (tableBody.scrollHeight > this.table.clientHeight) {
      // eslint-disable-next-line no-magic-numbers
      this.setState({ height: this.table.clientHeight - 30 });
    } else {
      this.setState({ height: 0 });
    }
  };

  onPageSize = (page, pageSize) => {
    const { pagination = {} } = this.props;
    const { onPageChange, current } = pagination || {};
    let newPage = current;
    let newPageSize = pagination.pageSize;
    if (page !== undefined) {
      newPage = page;
    }
    if (pageSize !== undefined) {
      newPageSize = pageSize;
    }
    onPageChange && onPageChange(newPage, newPageSize);
  };

  render() {
    const { className, showSeg, segName, rowKey, dataSource, columns, total, scroll, pagination, rowSelection, pageOptions, ...other } = this.props;

    let _rowKey = rowKey;
    const { current, pageSize } = pagination || {};
    const { height } = this.state;
    if (showSeg) {
      columns.map(e => {
        if (e.dataIndex === segName) {
          e.render = (value, record, index) => {
            return <span>{(current - 1) * pageSize + (index + 1)}</span>;
          };
        }
        e.className = `${e.className ? e.className : `${e.tdAlign ? `eb-gridtable-td-${e.tdAlign}` : ''} ${e.thAlign ? `eb-gridtable-th-${e.thAlign}` : ''}`}`;
        return e;
      });
    }

    console.log('scroll, height', scroll, height);
    console.log('classnames', classnames('eb-gridtable', className));

    return (
      <div className={classnames('eb-gridtable', className)}>
        <div ref={node => (this.table = node)} className="eb-gridtable-content">
          <Table
            columns={columns}
            rowKey={_rowKey}
            dataSource={[...dataSource]}
            pagination={false}
            scroll={scroll ? scroll : height ? { y: height } : undefined}
            rowSelection={rowSelection}
            {...other}
          />
        </div>
        {pagination && (
          <div className="eb-datagrid-footer">
            <Pagination
              total={total}
              showTotal={e => `共${e}条`}
              pageSize={pageSize}
              current={current}
              showQuickJumper
              showSizeChanger
              {...pageOptions}
              onShowSizeChange={this.onPageSize}
              onChange={this.onPageSize}
            />
          </div>
        )}
      </div>
    );
  }
}

export default ComTable;
