import React, { Component } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import ImageConsts from '@gm/graphmod-assets';
import Hikvideo from './hikvideo';
import FlvPlay from './flvvideo';
import Pagination from './Pagination';
import './VideoMatrix.scss';
/**
 * 视屏矩阵（1、4、9宫格）
 *
 * @class VideoMatrix
 * @extends {Component}
 */
class VideoMatrix extends Component {

  static propTypes = {
    videos: PropTypes.array,
    header: PropTypes.func,
    title: PropTypes.func,
    content: PropTypes.any,
    matrix: PropTypes.number,
    more: PropTypes.func,
    dataConfig: {}
  };

  static defaultProps = {
    videos: []
  };

  constructor(props) {
    super(props);
    this.state = {};
  }


  render() {
    const { videos, title, content, matrix, header, more, dataConfig: { videoMore = true } } = this.props;
    return (
      <div className={classnames('mod-com-videomatrix', `mod-com-videomatrix-${matrix}`)}>
        {videos.map(e => (
          <div key={e.id} className="mod-com-videomatrix-item">
            <div className="mod-com-videomatrix-header">
              {!header && title ? (
                <div className="mod-com-videomatrix-title">
                  <img src={ImageConsts.common.vedioLogo} alt="" />
                  {title(e)}
                </div>
              ) : null}
              {header && header(e)}
              {!header && videoMore ? (
                <div className="mod-com-videomatrix-more" onClick={event => more(e, event)}>
                  <img src={ImageConsts.common.listView} alt="" />
                </div>
              ) : null}
            </div>
            <div className="mod-com-videomatrix-content">{content}</div>
            {window.vedioFormat === 'flv' ? <FlvPlay vedioId={`video${e.id}`} token={e.token} liveVideoHost={e.url} code={e.code}/>
              : <Hikvideo vedioId={`video${e.id}`} token={e.token} liveVideoHost={e.url} code={e.code}/>
            }
          </div>
        ))}
      </div>
    );
  }
}

VideoMatrix.Pagination = Pagination;

export default VideoMatrix;
