/**
 * webpack 打包配置文件
 * @author ilex
 */
const simpleConfig = require('amos-build/lib/simpleConfig');
const __ENV__ = require('amos-build/lib/tools/__ENV__');
const { proxy } = require('./_proxy');

const isProd = __ENV__ === 'production';

// ------------------------------------------------------
// 添加webpack加载别名,用于导包重定向，优化打包以及代码
// 此处需要自己进行定义
// 👻可修改
// ------------------------------------------------------
const alias = {};

// ------------------------------------
// 入口点
// ------------------------------------
const entry = {
  app: './example/index.js'
};

const config = {
  tpl: './tpl.html',
  toFile: 'index.html',
  port: 3990,
  alias,
  entry,
  // 启动 WebWorker
  enableWorker: true,
  sourceMap: isProd ? false : true
};

const defaultConfig = simpleConfig(config);

if (!isProd) {
  // 开发模式下，配置 proxy，跳过跨域问题
  defaultConfig.devServer.proxy = proxy;
}

module.exports = defaultConfig;
