/**
 * webpack 打包配置文件
 * @author ilex
 */
const MFConfig = require('amos-build/lib/MFConfig');
const { getMfConfigInfo } = require('amos-build/lib/tools/pluginConfig');
const __ENV__ = require('amos-build/lib/tools/__ENV__');
const { proxy } = require('./_proxy');

const isProd = __ENV__ === 'production';

const mfInfo = getMfConfigInfo('../../');

const mfOption = {
  remotes: mfInfo.remotes,
  shared: mfInfo.shared
};

// ------------------------------------
// 入口点
// ------------------------------------
const entry = {
  app: './example/index.js'
};

const config = {
  tpl: './tpl.html',
  toFile: 'index.html',
  port: 3990,
  entry,
  mfMode: 'host',
  mfConfig: mfOption,
  // 启动 WebWorker
  enableWorker: true,
  sourceMap: isProd ? false : true,
  // 用于替换引入路径，修改为 mf 暴露的路径
  replacer: mfInfo.replacer
};

module.exports = function customDev(args = {}) {
  const devConfig = MFConfig({
    ...config,
    ...args
  });

  if (!isProd) {
    // 开发模式下，配置 proxy，跳过跨域问题
    devConfig.devServer.proxy = proxy;
  }

  // 由于 平台的 mf 中设置了 external
  // 引入外部 模块，需要将 react react-dom amos-react-router, 以防止多个 history 问题。只需要考虑 umd 模式
  devConfig.externals = {
    // 'react': 'React',
    // 'react-dom': 'ReactDOM',
    'amos-react-router': 'ReactRouter'
  };

  return devConfig;
};
