/**
 * 枚举类
 * 格式:
 *  const jobActivityTypeEnum = new EsEnums([
      { code: 'Technical', value: 0, label: '技术交底' },
      { code: 'ThreeHandCheck', value: 1, label: '三交三查' },
      { code: 'ViolationMgmt', value: 2, label: '违章作业' }
    ]);
 */
class EsEnum {
  constructor(arr) {
    let codeArr = [];

    if (!Array.isArray(arr)) {
      throw new Error('arr is not an array!');
    }

    arr.map(element => {
      if (!element.code || !element.label) {
        return;
      }
      // 保存code值组成的数组，方便A.getName(name)类型的调用
      codeArr.push(element.code);
      // 根据code生成不同属性值，以便A.B.name类型的调用
      this[element.code] = element;
      return element;
    });

    // 保存源数组
    this.arr = arr;
    this.codeArr = codeArr;
  }

  /**
   * 根据code得到对象
   * @param {*} code
   */
  valueOf = (code) => {
    return this.arr[this.codeArr.indexOf(code)] || [];
  }

  /**
   * 根据code获取label值
   * @param {*} code
   */
  getLabelByCode = (code) => {
    let prop = this.valueOf(code);
    if (!prop) {
      return '';
    }

    return prop.label;
  }
  /**
   * 根据value获取label值
   * @param {*} value
   */
  getLabelByValue = (value) => {
    let prop = this.arr.find(e => e.value === value);
    if (!prop) {
      return '';
    }
    return prop.label;
  }
  /**
 * 根据value获取label值
 * @param {*} value
 */
  getLabelByOther = (key, value) => {
    let prop = this.arr.find(e => e[key] === value);
    if (!prop) {
      return '';
    }
    return prop.label;
  }
  /**
   * 根据value获取其他属性值
   * @param {*} value
   */
  getOtherByValue = (value, key) => {
    let prop = this.arr.find(e => e.value === value);
    if (!prop) {
      return null;
    }
    return prop[key];
  }
  /**
 * 根据其他属性值获取其他属性值
 * @param {*} value
 */
  getOtherByLabel = (value, key) => {
    let prop = this.arr.find(e => e.label === value);
    if (!prop) {
      return null;
    }
    return prop[key];
  }
  /**
   * 根据value获取对象
   * @param {*} value
   */
  getObjByValue = (value) => {
    let prop = this.arr.find(e => e.value === value);
    if (!prop) {
      return null;
    }
    return prop;
  }
  /**
   * 返回源数组
   */
  getValues = () => {
    return this.arr;
  }
}

export default EsEnum;
