/**
 * webpack 打包配置文件
 * @author ilex
 */
const MFConfig = require('amos-build/lib/MFConfig');
const { getMfConfigInfo, getRCConfigInfo } = require('amos-build/lib/tools/pluginConfig');
const resolveApp = require('amos-build/lib/tools/resolveApp');
const removeFile = require('amos-build/lib/tools/removeFile');
const { configs } = require('./src/config');


const mfInfo = getMfConfigInfo('..');
const umdRc = getRCConfigInfo('umd', '..');

// Atapter工具库
const mfEntry = './src/atl.js';
const vname = 'lib/atl_v1.0.0.0';

const mfOption = {
  name: 'amosgm',
  library: { type: 'var', name: 'amosgm' },
  remotes: mfInfo.remotes,
  shared: mfInfo.shared,
  filename: 'remoteEntry.js',
  exposes: {
    './graphmod': mfEntry
  }
};


/**
 * 创建 sdk 编译脚本
 * @param {String} vname 项目版本名称，打包完成后会生成对应的文件夹名称，生成文件夹名称不能手动修改
 * @returns {}
 */
function sdk($vname = 'lib', configArgs = {}) {
  // 先删除已有版本
  // 采用版本管理每次发布，如果版本号不变，则无需删除指定版本
  removeFile($vname);

  // ------------------------------------------------------
  // 添加webpack加载别名,用于导包重定向，优化打包以及代码
  // 此处需要自己进行定义
  // 👻可修改
  // ------------------------------------------------------
  const alias = {};

  const replacer = configArgs.replacer
    ? {
      ...configArgs.replacer,
      ...mfInfo.replacer
    }
    : mfInfo.replacer;

  const config = {
    entry: {
      app: './src/index.js'
    },
    zipConfig: {
      copy: configs.map(e => ({ source: `./../${e.source}`, destination: `${$vname}/${e.name}.config.json` }))
    },
    outputPath: resolveApp($vname), // 如果使用版本管理，此处改为 resolveApp($vname)
    mfConfig: mfOption,
    mfMode: 'both',
    lint: false,
    alias,
    // 启动 WebWorker
    enableWorker: true,
    sourceMap: false,
    // 分析包 module 模块
    // analyzer: {
    //   analyzerPort: 10010
    // },
    ...configArgs,
    replacer,
    gzip: {
      // 删除原始的文件，仅保留 gzip 文件。需要给开发模式提供 mf 时，建议设置为 false
      // 由于 nginx 环境下，try_files 必须存在原始的 js，因此此处设置为 false
      deleteOriginalAssets: false
    }
  };

  const defaultConfig = MFConfig(config);

  // 设置 外部脚本配置
  defaultConfig.externals = umdRc.externals;

  return defaultConfig;
}

module.exports = sdk(vname);
