package com.yeejoin.amos.api.tool.face.model;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.typroject.tyboot.core.rdbms.model.BaseModel;


@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName(autoResultMap = true)
@ApiModel(value="TplModel", description="")
public class TplModel extends BaseModel {
    @ApiModelProperty(value = "展示名称")
    protected String displayName;

    @ApiModelProperty(value = "模板标识")
    protected String comKey;

    @ApiModelProperty(value = "模板名称")
    protected String comName;

    @ApiModelProperty(value = "模板内容")
    @TableField(typeHandler = JacksonTypeHandler.class)
    protected JSONObject content;

    @ApiModelProperty(value = "分类ID")
    protected Long cateSeq;

    @ApiModelProperty(value = "模板状态")
    protected Boolean openStatus;

    @ApiModelProperty(value = "缩略图")
    protected String thumb;

    @ApiModelProperty(value = "效果图")
    protected String sketch;

    @ApiModelProperty(value = "是否删除")
    protected Boolean isDel;


    public void setThumb(String thumb) {
        this.thumb = thumb ;
    }

    public void setSketch(String sketch) {
        this.sketch = sketch;
    }

    public TplModel(JSONObject content, String displayName, String comKey, String comName, Long cateSeq, Boolean openStatus, Boolean isDel){
        this.content = content;
        this.displayName =displayName;
        this.comKey = comKey;
        this.comName = comName;
        this.cateSeq = cateSeq;
        this.openStatus = openStatus;
        this.isDel = isDel;
    }

}
