package com.yeejoin.amos.api.tool.face.service;


import com.yeejoin.amos.api.tool.face.model.TplCateModel;
import com.yeejoin.amos.api.tool.face.model.TplCateTreeModel;
import com.yeejoin.amos.api.tool.face.model.VisualDesignerModel;
import com.yeejoin.amos.api.tool.face.orm.dao.VisualDesignerMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.VisualDesigner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class VisualDesignerService extends BaseService<VisualDesignerModel, VisualDesigner, VisualDesignerMapper> {

    @Autowired
    TplCateService tplCateService;
    @Autowired
    VisualDesignerService visualDesignerService;

    /**
     * 列表查询 示例
     */

    //    父List
    public List<VisualDesignerModel> queryForVisualDesignerList() {
        return this.queryForList("", false);
    }

    public List<TplCateTreeModel> getList() {
        List<TplCateTreeModel> treeList = new ArrayList<>();
        List<TplCateModel> tplCateModels = tplCateService.queryForTplCateList();
        List<VisualDesignerModel> visualDesignerModels = visualDesignerService.queryForVisualDesignerList();
        for(int i = 0; i < visualDesignerModels.size();i++){
            TplCateTreeModel tplCateTreeModel1 = new
                    TplCateTreeModel(visualDesignerModels.get(i).getSequenceNbr(), 0L,
                    visualDesignerModels.get(i).getDesignerName(),visualDesignerModels.get(i).getDesignerType());
            for (int j = 0, index =0 ;j < tplCateModels.size();j++){
                if(tplCateModels.get(j).getDesignerType().equals(tplCateTreeModel1.getDesignerType())){
                    TplCateTreeModel tplCateTreeModel2 = new
                            TplCateTreeModel(tplCateModels.get(j).getSequenceNbr(), tplCateTreeModel1.getSequenceNbr(),
                            tplCateModels.get(j).getCateName(),tplCateTreeModel1.getDesignerType(),null);
                    tplCateTreeModel1.getChildren().add(index++,tplCateTreeModel2);
                }
            }
            treeList.add(i,tplCateTreeModel1);
        }
        return treeList;
    }

}