package com.yeejoin.amos.api.tool.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.TplModel;
import com.yeejoin.amos.api.tool.face.service.TplService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@CrossOrigin
@RestController
@Api(tags = "模板管理Api")
@RequestMapping(value = "/demo/tpl")
public class TplResource {

    @Autowired
    TplService tplService;

    /**
     * 新增
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<TplModel> save(@RequestBody TplModel tplModel) throws Exception{
        tplModel.setIsDel(false);
        tplModel.setDisplayName(tplModel.getComName());
        tplModel = tplService.createWithModel(tplModel);
        System.out.println(tplModel.getThumb());
        return ResponseHelper.buildResponse(tplModel);
    }
    /**
     * 根据sequenceNbr更新
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<TplModel> updateBySequenceNbrTpl(@RequestBody TplModel tplModel,@PathVariable(value = "sequenceNbr")Long sequenceNbr) {
        tplModel.setSequenceNbr(sequenceNbr);
        return  ResponseHelper.buildResponse(tplService.updateWithModel(tplModel));
    }

    /**
     * 根据sequenceNbr删除
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr")Long sequenceNbr){
        return  ResponseHelper.buildResponse(tplService.removeById(sequenceNbr));
    }
    /**
     * 根据sequenceNbr查询
     * @param sequenceNbr  主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
    public ResponseModel<TplModel> selectOne(@PathVariable Long sequenceNbr) throws Exception {
        return ResponseHelper.buildResponse(tplService.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *@param current 当前页
     *@param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
    public ResponseModel<Page<TplModel>> queryForPage(@RequestParam(value = "current") int current, @RequestParam(value = "size") int size,@RequestParam(value = "categorySeq")Long categorySeq){
        Page<TplModel> page = new Page<TplModel>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(tplService.queryForTplPage(page,categorySeq));
    }
    /**
     *列表全部数据查询
     *@return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<TplModel>> selectForList(){
        return ResponseHelper.buildResponse(tplService.queryForTplList());
    }
}
