package com.yeejoin.amos.api.tool.face.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="TplCateModel", description="")
public class TplModel extends BaseModel {

    @ApiModelProperty(value = "展示名称")
    private String displayName;

    @ApiModelProperty(value = "模板标识")
    private String comKey;

    @ApiModelProperty(value = "模板名称")
    private String comName;

    @ApiModelProperty(value = "模板内容")
    private String content;

    @ApiModelProperty(value = "分类ID")
    private String cateSeq;

    @ApiModelProperty(value = "模板状态")
    private Boolean openStatus;

    @ApiModelProperty(value = "缩略图")
    private MultipartFile thumb;

    @ApiModelProperty(value = "效果图")
    private String sketch;

    @ApiModelProperty(value = "是否删除")
    private Boolean isDel;

    public void setIsDel(Boolean isDel) {
        this.isDel = isDel;
    }

    public String getComName() {
        return comName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }


}
