package com.yeejoin.amos.api.tool.controller;

import com.yeejoin.amos.api.tool.face.model.ApiInfoModel;
import com.yeejoin.amos.api.tool.face.model.ApiSourceModel;
import com.yeejoin.amos.api.tool.face.model.TplModel;
import com.yeejoin.amos.api.tool.face.service.ApiInfoService;
import com.yeejoin.amos.api.tool.face.service.ApiSourceService;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

@CrossOrigin
@RestController
@Api(tags = "接口来源管理Api")
@RequestMapping(value = "/demo/api_source")
public class ApiSourceResource {

    @Autowired
    ApiSourceService apiSourceService;
    @Autowired
    ApiInfoService apiInfoService;

    /**
     * 新增
     *
     * @return ApiSourceDto
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<ApiSourceModel> save(@RequestBody ApiSourceModel model) {
        model = apiSourceService.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 编码
     * @return ApiSourceDto
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<ApiSourceModel> updateBySeqApiSource(@RequestBody ApiSourceModel model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(apiSourceService.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 编码
     * @return Boolean
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        List<ApiInfoModel> apiInfoModels = apiInfoService.queryForApiInfoListBySeq(apiSourceService.queryCodeById(sequenceNbr));
        for (ApiInfoModel apiInfoModel:apiInfoModels){
            apiInfoService.removeById(apiInfoModel.getSequenceNbr());
        }
        return ResponseHelper.buildResponse(apiSourceService.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 物理主键
     * @return ApiSourceDto
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<ApiSourceModel> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(apiSourceService.queryBySeq(sequenceNbr));
    }


    /**
     * 列表全部数据查询
     *
     * @return List<ApiSourceDto>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<ApiSourceModel>> selectForList() {
        return ResponseHelper.buildResponse(apiSourceService.queryForApiSourceList());
    }

}
