package com.yeejoin.amos.api.tool.face.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.TplModel;
import com.yeejoin.amos.api.tool.face.model.TplVoModel;
import com.yeejoin.amos.api.tool.face.orm.dao.TplMapper;
import com.yeejoin.amos.api.tool.face.orm.entity.Tpl;
import org.apache.commons.beanutils.ConvertUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;

@Service
public class TplService extends BaseService<TplModel, Tpl, TplMapper> {
    /**
     * 分页查询
     */
    public Page<TplModel> queryForTplPage(Page<TplModel> page, Long categorySeq, String displayName)   {
            return this.queryForPage(page, null, false, categorySeq, displayName);
    }


    /**
     * 列表查询
     */
    public List<TplModel> queryForTplListByCategorySeq(Long categorySeq)   {
        return this.queryForList("" , false,categorySeq);
    }
    /**
     * 列表查询
     */
    public List<TplModel> queryForTplList()   {
        return this.queryForList("" , false);
    }


    /**
     * TplVoModel转化TplModel
     */
    public TplModel convertModel(TplVoModel tplVoModel,TplModel tplModel){
        BeanUtils.copyProperties(tplVoModel,tplModel,"thumbs","sketches","contentStr");
        //判定thumbs为空
        if(tplVoModel.getThumbs().size() != 0)
            tplModel.setThumb(tplVoModel.getThumbs().get(0).getUrl());
        //判定sketch为空
        if(tplVoModel.getSketches().size() !=0)
            tplModel.setSketch(tplVoModel.getSketches().get(0).getUrl());
        tplModel.setContent(JSON.parseObject(tplVoModel.getContentStr()));
        return tplModel;
    }
    /**
     * 删除多个模板
     */
    public Boolean[] deleteByIds(String sequenceNbr){
        String[] arr = sequenceNbr.split(",");
        Long[] seq = (Long[]) ConvertUtils.convert(arr, Long.class);
        Boolean[] arr2 = new Boolean[arr.length];
        for (int i = 0;i < arr.length;i++){
            arr2[i] = this.removeById(seq[i]);
        }
        return arr2;
    }
    /**
     * 读取json文件
     */
    public String readMultipartFile(MultipartFile multipartFile) throws IOException {
        Reader reader = new InputStreamReader(multipartFile.getInputStream(), "utf-8");
        int ch = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((ch = reader.read()) != -1) {
            stringBuffer.append((char) ch);
        }
        reader.close();
        return stringBuffer.toString();
    }


}
