package com.yeejoin.amos.api.tool.controller;

import com.yeejoin.amos.api.tool.face.model.TplCateModel;
import com.yeejoin.amos.api.tool.face.model.TplCateTreeModel;
import com.yeejoin.amos.api.tool.face.service.TplCateService;
import com.yeejoin.amos.api.tool.face.service.VisualDesignerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

@CrossOrigin
@RestController
@Api(tags = "模板分类管理Api")
@RequestMapping(value = "/demo/tpl_cate")
public class TplCateResource {

    @Autowired
    TplCateService tplCateService;

    @Autowired
    VisualDesignerService visualDesignerService;

    /**
     * 新增
     *
     * @return ApiSourceDto
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<TplCateModel> save(@RequestBody TplCateModel tplCate){
        tplCate.setIcon("");
        tplCate.setIsDel(false);
        tplCate = tplCateService.createWithModel(tplCate);
        return ResponseHelper.buildResponse(tplCate);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 编码
     * @return ApiSourceDto
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<TplCateModel> updateBySeqTplCate(@RequestBody TplCateModel tplCateModel,@PathVariable(value = "sequenceNbr") Long sequenceNbr){
        tplCateModel.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(tplCateService.updateWithModel(tplCateModel));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 编码
     * @return Boolean
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(tplCateService.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 物理主键
     * @return ApiSourceDto
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public  ResponseModel<TplCateModel> selectOne(@PathVariable Long sequenceNbr){
        return ResponseHelper.buildResponse(tplCateService.queryBySeq(sequenceNbr));
    }

    /**
     * 列表全部数据查询
     *
     * @return List<ApiSourceDto>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<TplCateModel>> selectForList(){
        return ResponseHelper.buildResponse(tplCateService.queryForTplCateList());
    }
    /**
     * 列表树形结构查询
     *
     * @return List<ApiSourceDto>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "列表树形结构查询", notes = "列表树形结构查询")
    @GetMapping(value = "/tree")
    public ResponseModel<List<TplCateTreeModel>> selectForTree(){
        return ResponseHelper.buildResponse(visualDesignerService.getList());
    }

}
