package com.yeejoin.amos.api.tool.face.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

@Data
@NoArgsConstructor
@ApiModel(value="TplCateModel", description="")
public class TplCateTreeModel {
    @ApiModelProperty(value = "物理主键")
    private Long sequenceNbr;

    @ApiModelProperty(value = "父ID")
    private Long parentId;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "设计器类型")
    private String designerType;

    @ApiModelProperty(value = "子列表")
    private List<TplCateTreeModel> children = new ArrayList<TplCateTreeModel>();

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public TplCateTreeModel(Long sequenceNbr, Long parentId, String name,String designerType){
        this.sequenceNbr =sequenceNbr ;
        this.parentId = parentId;
        this.name = name;
        this.designerType =designerType;
    }
    public TplCateTreeModel(Long sequenceNbr, Long parentId, String name,String designerType,List<TplCateTreeModel> children){
        this.sequenceNbr =sequenceNbr ;
        this.parentId = parentId;
        this.name = name;
        this.designerType =designerType;
        this.children = children;
    }

}
