package com.yeejoin.amos.api.tool.face.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

import java.util.ArrayList;
import java.util.List;

@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="TplVoModel", description="")
@JsonIgnoreProperties({"hibernateLazyInitializer","handler"})
public class TplVoModel extends BaseModel {

    @ApiModelProperty(value = "展示名称")
    public String displayName;

    @ApiModelProperty(value = "模板标识")
    public String comKey;

    @ApiModelProperty(value = "模板名称")
    public String comName;

    @ApiModelProperty(value = "模板内容")
    public String content;

    @ApiModelProperty(value = "分类ID")
    public Long cateSeq;

    @ApiModelProperty(value = "模板状态")
    public Boolean openStatus;

    @ApiModelProperty(value = "缩略图")
    private List<PicModel> thumbs = new ArrayList<>();

    @ApiModelProperty(value = "效果图")
    private List<PicModel> sketches = new ArrayList<>();

    @ApiModelProperty(value = "是否删除")
    public Boolean isDel;

    public void setIsDel(Boolean isDel) {
        this.isDel = isDel;
    }

    public String getComName() {
        return comName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

}
