package com.yeejoin.amos.api.tool.controller;

import com.yeejoin.amos.api.tool.face.model.AgencyTreeModel;
import com.yeejoin.amos.api.tool.face.service.AgencyTreeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
 * @author r
 */
@RestController
@Api(tags = "机构树")
@RequestMapping(value = "/privilege_agency")
public class AgencyTreeResource {

    @Autowired
    AgencyTreeService agencyTreeService;

    /**
     * 根据sequenceNbr删除
     * @param sequenceNbr 主键
     * @return Boolean
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(agencyTreeService.removeById(sequenceNbr));
    }


    /**
     *列表全部数据查询
     * @return List<AgencyTreeModel>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<AgencyTreeModel>> selectForList() {
        return ResponseHelper.buildResponse(agencyTreeService.queryForAgencyTreeList());
    }
}
