package com.yeejoin.amos.api.tool.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.DataBaseModel;
import com.yeejoin.amos.api.tool.face.service.DataBaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.beanutils.ConvertUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
 * @author r
 */
@RestController
@Api(tags = "数据库信息")
@RequestMapping(value = "/database_join_record")
public class DataBaseResource {

    @Autowired
    DataBaseService dataBaseService;

    /**
     * 数据库初始化
     * @param dataBaseModel 数据库连接信息
     * @return  List<DataBaseModel>
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/refresh")
    @ApiOperation(httpMethod = "POST", value = "数据库初始化", notes = "数据库初始化")
    public ResponseModel<List<DataBaseModel>> save(@RequestBody DataBaseModel dataBaseModel) throws Exception {
        List<DataBaseModel> dataBaseModels = dataBaseService.refreshDataBase(dataBaseModel);
        if (dataBaseModels == null)
            return null;
        else
            return ResponseHelper.buildResponse(dataBaseModels);
    }

    /**
     * 根据sequenceNbr批量删除
     * @param sequenceNbr 物理主键
     * @return Boolean[]
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/delete/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "批量删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean[]> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") String sequenceNbr) {
        String Nbr[] = sequenceNbr.split(",");
        Long[] seq = (Long[]) ConvertUtils.convert(Nbr, Long.class);

        Boolean Nbr2[] = new Boolean[Nbr.length];
        for (int i = 0; i < Nbr.length; i++) {
            Nbr2[i] = dataBaseService.removeById(seq[i]);
        }
        return ResponseHelper.buildResponse(Nbr2);
    }

    /**
     * 列表分页查询
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<DataBaseModel>> queryForPage(@RequestParam(value = "current") int current, @RequestParam(value = "size") int size) {
        Page<DataBaseModel> page = new Page<DataBaseModel>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(dataBaseService.queryForDataBasePage(page));
    }

    /**
     * 列表全部数据查询
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<DataBaseModel>> selectForList() {
        return ResponseHelper.buildResponse(dataBaseService.queryForDataBaseList());
    }
}
