package com.yeejoin.amos.api.tool.controller;

import com.yeejoin.amos.api.tool.face.service.DataBaseLinkService;
import com.yeejoin.amos.api.tool.face.service.RelationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;


@CrossOrigin
@RestController
@Api(tags = "机构管理Api")
@RequestMapping(value = "/Agency")
public class RelationResource {
    @Autowired
    private RelationService relationService;
    @Autowired
    DataBaseLinkService dataBaseLinkService;

    /**
     * 根据机构ID和数据库sequenceNbr批量删除数据库
     *
     * @param agencyCode 机构ID
     * @param sequenceNbrs 多个主键
     * @return String
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/relation/{agencyCode}/{sequenceNbrs}")
    @ApiOperation(httpMethod = "DELETE", value = "机构删除", notes = "机构删除")
    public ResponseModel<String> deleteDataBase(
            @PathVariable String agencyCode,
            @PathVariable String sequenceNbrs) throws Exception {
        relationService.deleteAgency(agencyCode, sequenceNbrs);
        return ResponseHelper.buildResponse("The data has been deleted !");
    }

    /**
     * 导出SQL脚本
     *
     * @return String
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/output/{agencyCode}/{sequenceNbrs}")
    @ApiOperation(httpMethod = "GET", value = "导出", notes = "导出")

    public ResponseModel<String> generateSQL(
            @PathVariable String agencyCode,
            @PathVariable String sequenceNbrs,
            HttpServletResponse response) throws Exception {
        relationService.outputAgency(agencyCode, sequenceNbrs,response);
        return ResponseHelper.buildResponse("yes");
    }
}