package com.yeejoin.amos.api.tool.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.tool.face.model.TplModel;
import com.yeejoin.amos.api.tool.face.model.TplVoModel;
import com.yeejoin.amos.api.tool.face.service.TplService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

@CrossOrigin
@RestController
@Api(tags = "模板管理Api")
@RequestMapping(value = "/tpl")
public class TplResource {

    @Autowired
    TplService tplService;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<TplModel> save(@RequestBody TplVoModel tplVoModel) throws Exception {
        tplVoModel.setIsDel(false);
        tplVoModel.setDisplayName(tplVoModel.getComName());
        TplModel tplModel = new TplModel();
        tplService.convertModel(tplVoModel, tplModel);
        return ResponseHelper.buildResponse(tplService.createWithModel(tplModel));
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<TplModel> updateBySequenceNbrTpl(@RequestBody TplVoModel tplVoModel, @PathVariable(value = "sequenceNbr") Long sequenceNbr) throws NoSuchFieldException, IllegalAccessException {
        tplVoModel.setSequenceNbr(sequenceNbr);
        tplVoModel.setDisplayName(tplVoModel.getComName());
        TplModel tplModel = new TplModel();
        tplService.convertModel(tplVoModel, tplModel);
        return ResponseHelper.buildResponse(tplService.updateWithModel(tplModel));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(tplService.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr删除多项
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/s/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除多项", notes = "根据sequenceNbr删除多项")
    public ResponseModel<String> deleteModelsBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") String sequenceNbr) {
        tplService.deleteByIds(sequenceNbr);
        return ResponseHelper.buildResponse("Succeed!");
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<TplVoModel> selectOne(@PathVariable Long sequenceNbr) throws Exception {
        TplModel tplModel = tplService.queryBySeq(sequenceNbr);
        TplVoModel tplVoModel = tplService.convertVoModel(tplModel);
        if (tplModel.getContent() != null) tplVoModel.setContentStr(tplModel.getContent().toString());
        return ResponseHelper.buildResponse(tplVoModel);
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param size    每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<TplModel>> queryForPage(@RequestParam(value = "current") int current, @RequestParam(value = "size") int size, @RequestParam(value = "categorySeq") Long categorySeq, @RequestParam(value = "displayName", required = false) String displayName) {
        Page<TplModel> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(tplService.queryForTplPage(page, categorySeq, displayName));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<TplModel>> selectForList() {
        return ResponseHelper.buildResponse(tplService.queryForTplList());
    }

    /**
     * 导入
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @CrossOrigin
    @ApiOperation(httpMethod = "POST", value = "根据sequenceNbr导入content", notes = "根据sequenceNbr导入content")
    @PostMapping(value = "/import")
    public ResponseModel<TplModel> importTpl(@RequestParam("file") MultipartFile multipartFile) throws Exception {
        JSONObject content = JSON.parseObject(tplService.readMultipartFile(multipartFile));
        String str = "1668429235251548162";
        TplModel tplModel = new TplModel(content, "", "", "", Long.parseLong(str), false, false);
        return ResponseHelper.buildResponse(tplService.createWithModel(tplModel));
    }

}
