package com.yeejoin.amos.api.tool.controller;

import com.yeejoin.amos.api.tool.face.service.TransferDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.sql.SQLException;

@CrossOrigin
@RestController
@Api(tags = "数据迁移")
@RequestMapping(value = "/transfer_data")
public class TransferDataResource {

    @Autowired
    private TransferDataService transferDataService;
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PutMapping(value = "/relation/")
    @ApiOperation(httpMethod = "Put", value = "数据迁移", notes = "数据迁移")
    public ResponseModel<String> transferData( ) throws SQLException, ClassNotFoundException {
        transferDataService.transferData();
        return ResponseHelper.buildResponse("The data has been transferred !");
    }
}
