package com.yeejoin.amos.api.tool.face.model;


import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.yeejoin.amos.api.tool.face.util.PicUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="TplVoModel", description="")
@JsonIgnoreProperties({"hibernateLazyInitializer","handler"})
public class TplVoModel extends TplModel {

    @ApiModelProperty(value = "模板内容")
    private String contentStr;

    @ApiModelProperty(value = "缩略图")
    private List<PicModel> thumbs = new ArrayList<>();

    @ApiModelProperty(value = "效果图")
    private List<PicModel> sketches = new ArrayList<>();

    public void setIsDel(Boolean isDel) {
        this.isDel = isDel;
    }

    public String getComName() {
        return comName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

}
