package com.yeejoin.amos.api.tool.face.orm.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.api.tool.face.model.AmosToolTemplateModel;
import com.yeejoin.amos.api.tool.face.orm.entity.AmosToolTemplate;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import java.util.List;

@Mapper
public interface AmosToolTemplateMapper extends BaseMapper<AmosToolTemplate> {
    /**
     * 全部
     */
    @Select("select * from amos_tool_template" +
            " order by ${miniSences} ${way}")
    List<AmosToolTemplateModel> listAll(@Param("miniSences") String miniSences,
                                        @Param("way") String way);

    /**
     * 具体场景
     */
    @Select("select * from amos_tool_template" +
            " where CATEGORY_SCENE=#{categoryScene} order by `${miniSences}` ${way}")
    List<AmosToolTemplateModel> queryByScenes(@Param("categoryScene") String categoryScene,
                                              @Param("miniSences") String miniSences, @Param("way") String way);


    /**
     * 点击查看次数加一
     */
    @Update("update amos_tool_template set VIEW_TIMES = VIEW_TIMES+1 where SEQUENCE_NBR = #{sequenceNbr}")
    boolean updateTimesById(@Param("sequenceNbr") Long sequenceNbr);
}
