package com.yeejoin.amos.api.tool.face.orm.entity;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "studio_template",autoResultMap = true)
public class Tpl extends BaseEntity {


    /**
     *展示名称
     */
    @TableField(value = "DISPLAY_NAME",condition = SqlCondition.LIKE)
    private String displayName;

    /**
     *模板标识
     */
    @TableField("COMPONENT_KEY")
    private String comKey;

    /**
     *模板名称
     */
    @TableField("COMPONENT_NAME")
    private String comName;

    /**
     *模板内容
     */
    @TableField(value = "CONTENT",typeHandler = JacksonTypeHandler.class)
    private JSONObject content;

    /**
     *分类ID
     */
    @TableField("CATEGORY_SEQ")
    private Long cateSeq;

    /**
     *模板状态
     */
    @TableField("OPEN_STATUS")
    private Boolean openStatus;

    /**
     *缩略图
     */
    @TableField("THUMB")
    private String thumb;

    /**
     *状态图
     */
    @TableField("SKETCH")
    private String sketch;

    /**
     *是否删除
     */
    @TableField("IS_DELETE")
    private Boolean isDel;
}
